/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.servicebus.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.servicebus.models.ProvisioningStateDR;
import com.azure.resourcemanager.servicebus.models.RoleDisasterRecovery;
import java.io.IOException;

public final class ArmDisasterRecoveryProperties
implements JsonSerializable<ArmDisasterRecoveryProperties> {
    private ProvisioningStateDR provisioningState;
    private Long pendingReplicationOperationsCount;
    private String partnerNamespace;
    private String alternateName;
    private RoleDisasterRecovery role;

    public ProvisioningStateDR provisioningState() {
        return this.provisioningState;
    }

    public Long pendingReplicationOperationsCount() {
        return this.pendingReplicationOperationsCount;
    }

    public String partnerNamespace() {
        return this.partnerNamespace;
    }

    public ArmDisasterRecoveryProperties withPartnerNamespace(String partnerNamespace) {
        this.partnerNamespace = partnerNamespace;
        return this;
    }

    public String alternateName() {
        return this.alternateName;
    }

    public ArmDisasterRecoveryProperties withAlternateName(String alternateName) {
        this.alternateName = alternateName;
        return this;
    }

    public RoleDisasterRecovery role() {
        return this.role;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("partnerNamespace", this.partnerNamespace);
        jsonWriter.writeStringField("alternateName", this.alternateName);
        return jsonWriter.writeEndObject();
    }

    public static ArmDisasterRecoveryProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ArmDisasterRecoveryProperties)jsonReader.readObject(reader -> {
            ArmDisasterRecoveryProperties deserializedArmDisasterRecoveryProperties = new ArmDisasterRecoveryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedArmDisasterRecoveryProperties.provisioningState = ProvisioningStateDR.fromString(reader.getString());
                    continue;
                }
                if ("pendingReplicationOperationsCount".equals(fieldName)) {
                    deserializedArmDisasterRecoveryProperties.pendingReplicationOperationsCount = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("partnerNamespace".equals(fieldName)) {
                    deserializedArmDisasterRecoveryProperties.partnerNamespace = reader.getString();
                    continue;
                }
                if ("alternateName".equals(fieldName)) {
                    deserializedArmDisasterRecoveryProperties.alternateName = reader.getString();
                    continue;
                }
                if ("role".equals(fieldName)) {
                    deserializedArmDisasterRecoveryProperties.role = RoleDisasterRecovery.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArmDisasterRecoveryProperties;
        });
    }
}

