/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.share;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.common.implementation.AccountSasImplUtil;
import com.azure.storage.common.implementation.SasImplUtils;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.AccountSasSignatureValues;
import com.azure.storage.file.share.ShareAsyncClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.azure.storage.file.share.ShareServiceVersion;
import com.azure.storage.file.share.implementation.AzureFileStorageImpl;
import com.azure.storage.file.share.implementation.models.DeleteSnapshotsOptionType;
import com.azure.storage.file.share.implementation.models.ListSharesIncludeType;
import com.azure.storage.file.share.implementation.util.ModelHelper;
import com.azure.storage.file.share.models.ListSharesOptions;
import com.azure.storage.file.share.models.ShareItem;
import com.azure.storage.file.share.models.ShareServiceProperties;
import com.azure.storage.file.share.options.ShareCreateOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ShareServiceClientBuilder.class, isAsync=true)
public final class ShareServiceAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(ShareServiceAsyncClient.class);
    private final AzureFileStorageImpl azureFileStorageClient;
    private final String accountName;
    private final ShareServiceVersion serviceVersion;
    private final AzureSasCredential sasToken;

    ShareServiceAsyncClient(AzureFileStorageImpl azureFileStorage, String accountName, ShareServiceVersion serviceVersion, AzureSasCredential sasToken) {
        this.azureFileStorageClient = azureFileStorage;
        this.accountName = accountName;
        this.serviceVersion = serviceVersion;
        this.sasToken = sasToken;
    }

    public String getFileServiceUrl() {
        return this.azureFileStorageClient.getUrl();
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public ShareAsyncClient getShareAsyncClient(String shareName) {
        return this.getShareAsyncClient(shareName, null);
    }

    public ShareAsyncClient getShareAsyncClient(String shareName, String snapshot) {
        return new ShareAsyncClient(this.azureFileStorageClient, shareName, snapshot, this.accountName, this.serviceVersion, this.sasToken);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareItem> listShares() {
        return this.listShares(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ShareItem> listShares(ListSharesOptions options) {
        try {
            return this.listSharesWithOptionalTimeout(null, options, null, Context.NONE);
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<ShareItem> listSharesWithOptionalTimeout(String marker, ListSharesOptions options, Duration timeout, Context context) {
        String prefix = options != null ? options.getPrefix() : null;
        Integer maxResultsPerPage = options != null ? options.getMaxResultsPerPage() : null;
        ArrayList<ListSharesIncludeType> include = new ArrayList<ListSharesIncludeType>();
        if (options != null) {
            if (options.isIncludeDeleted()) {
                include.add(ListSharesIncludeType.DELETED);
            }
            if (options.isIncludeMetadata()) {
                include.add(ListSharesIncludeType.METADATA);
            }
            if (options.isIncludeSnapshots()) {
                include.add(ListSharesIncludeType.SNAPSHOTS);
            }
        }
        BiFunction<String, Integer, Mono> retriever = (nextMarker, pageSize) -> StorageImplUtils.applyOptionalTimeout((Mono)this.azureFileStorageClient.getServices().listSharesSegmentSinglePageAsync(prefix, (String)nextMarker, pageSize == null ? maxResultsPerPage : pageSize, (List<ListSharesIncludeType>)include, null, context).map(response -> {
            List value = response.getValue() == null ? Collections.emptyList() : response.getValue().stream().map(ModelHelper::populateShareItem).collect(Collectors.toList());
            return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, (String)response.getContinuationToken(), (Object)ModelHelper.transformListSharesHeaders(response.getHeaders()));
        }), (Duration)timeout);
        return new PagedFlux(pageSize -> (Mono)retriever.apply(marker, (Integer)pageSize), retriever);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareServiceProperties> getProperties() {
        return this.getPropertiesWithResponse().flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareServiceProperties>> getPropertiesWithResponse() {
        try {
            return FluxUtil.withContext(this::getPropertiesWithResponse);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareServiceProperties>> getPropertiesWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getServices().getPropertiesWithResponseAsync(null, context).map(response -> new SimpleResponse((Response)response, (Object)((ShareServiceProperties)response.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setProperties(ShareServiceProperties properties) {
        return this.setPropertiesWithResponse(properties).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> setPropertiesWithResponse(ShareServiceProperties properties) {
        try {
            return FluxUtil.withContext(context -> this.setPropertiesWithResponse(properties, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> setPropertiesWithResponse(ShareServiceProperties properties, Context context) {
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getServices().setPropertiesNoCustomHeadersWithResponseAsync(properties, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareAsyncClient> createShare(String shareName) {
        return this.createShareWithResponse(shareName, (ShareCreateOptions)null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareAsyncClient>> createShareWithResponse(String shareName, Map<String, String> metadata, Integer quotaInGB) {
        return this.createShareWithResponse(shareName, new ShareCreateOptions().setMetadata(metadata).setQuotaInGb(quotaInGB));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareAsyncClient>> createShareWithResponse(String shareName, ShareCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createShareWithResponse(shareName, options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareAsyncClient>> createShareWithResponse(String shareName, ShareCreateOptions options, Context context) {
        ShareAsyncClient shareAsyncClient = new ShareAsyncClient(this.azureFileStorageClient, shareName, null, this.accountName, this.serviceVersion, this.sasToken);
        return shareAsyncClient.createWithResponse(options, context).map(response -> new SimpleResponse(response, (Object)shareAsyncClient));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteShare(String shareName) {
        return this.deleteShareWithResponse(shareName, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteShareWithResponse(String shareName, String snapshot) {
        try {
            return FluxUtil.withContext(context -> this.deleteShareWithResponse(shareName, snapshot, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteShareWithResponse(String shareName, String snapshot, Context context) {
        DeleteSnapshotsOptionType deleteSnapshots = null;
        if (CoreUtils.isNullOrEmpty((CharSequence)snapshot)) {
            deleteSnapshots = DeleteSnapshotsOptionType.INCLUDE;
        }
        context = context == null ? Context.NONE : context;
        return this.azureFileStorageClient.getShares().deleteNoCustomHeadersWithResponseAsync(shareName, snapshot, null, deleteSnapshots, null, context);
    }

    public String getAccountName() {
        return this.accountName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.azureFileStorageClient.getHttpPipeline();
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues) {
        return this.generateAccountSas(accountSasSignatureValues, Context.NONE);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Context context) {
        return this.generateAccountSas(accountSasSignatureValues, null, context);
    }

    public String generateAccountSas(AccountSasSignatureValues accountSasSignatureValues, Consumer<String> stringToSignHandler, Context context) {
        return new AccountSasImplUtil(accountSasSignatureValues, null).generateSas(SasImplUtils.extractSharedKeyCredential((HttpPipeline)this.getHttpPipeline()), stringToSignHandler, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ShareAsyncClient> undeleteShare(String deletedShareName, String deletedShareVersion) {
        return this.undeleteShareWithResponse(deletedShareName, deletedShareVersion).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ShareAsyncClient>> undeleteShareWithResponse(String deletedShareName, String deletedShareVersion) {
        try {
            return FluxUtil.withContext(context -> this.undeleteShareWithResponse(deletedShareName, deletedShareVersion, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<ShareAsyncClient>> undeleteShareWithResponse(String deletedShareName, String deletedShareVersion, Context context) {
        return this.azureFileStorageClient.getShares().restoreWithResponseAsync(deletedShareName, null, null, deletedShareName, deletedShareVersion, context).map(response -> new SimpleResponse((Response)response, (Object)this.getShareAsyncClient(deletedShareName)));
    }
}

