/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.azurekeyvaultplugin.credentials.secretfile;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.function.Supplier;
import org.jenkinsci.plugins.azurekeyvaultplugin.AzureCredentialsProvider;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.Messages;
import org.jvnet.localizer.ResourceBundleHolder;

public class AzureSecretFileCredentials
extends BaseStandardCredentials
implements FileCredentials {
    @NonNull
    private final String fileName;
    @NonNull
    private final Supplier<Secret> secretBytes;

    public AzureSecretFileCredentials(CredentialsScope scope, String id, String description, String fileName, Supplier<Secret> secretBytes) {
        super(scope, id, description);
        this.fileName = fileName;
        this.secretBytes = secretBytes;
    }

    @NonNull
    public String getFileName() {
        return this.fileName;
    }

    @NonNull
    public InputStream getContent() throws UnsupportedEncodingException {
        String fileContent = Secret.toString((Secret)this.getSecretBytes());
        return new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
    }

    public Secret getSecretBytes() {
        return this.secretBytes.get();
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return ResourceBundleHolder.get(Messages.class).format("FileCredentialsImpl.secret_file", new Object[0]);
        }

        public boolean isApplicable(CredentialsProvider provider) {
            return provider instanceof AzureCredentialsProvider;
        }
    }
}

