/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.credentials;

import com.azure.resourcemanager.AzureResourceManager;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.microsoft.jenkins.credentials.AzureResourceManagerRetriever;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.time.Duration;
import java.util.Objects;

public final class AzureResourceManagerCache {
    private static final long MAX_SIZE = 50L;
    private static final Duration EXPIRE_AFTER = Duration.ofHours(24L);
    private static final LoadingCache<CacheKey, AzureResourceManager> CACHE = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(EXPIRE_AFTER).build(AzureResourceManagerCache::createClient);

    private AzureResourceManagerCache() {
    }

    @CheckForNull
    public static AzureResourceManager get(String credentialsId) {
        return (AzureResourceManager)CACHE.get((Object)new CacheKey(credentialsId));
    }

    @CheckForNull
    public static AzureResourceManager get(String credentialsId, String subscriptionId) {
        return (AzureResourceManager)CACHE.get((Object)new CacheKey(credentialsId, subscriptionId));
    }

    public static void invalidateCache() {
        CACHE.invalidateAll();
    }

    private static AzureResourceManager createClient(CacheKey key) {
        return AzureResourceManagerRetriever.getClient(key.credentialsId, key.subscriptionId);
    }

    private static class CacheKey {
        private final String credentialsId;
        private final String subscriptionId;

        CacheKey(String credentialsId) {
            this.credentialsId = credentialsId;
            this.subscriptionId = null;
        }

        CacheKey(String credentialsId, String subscriptionId) {
            this.credentialsId = credentialsId;
            this.subscriptionId = subscriptionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.credentialsId.equals(cacheKey.credentialsId) && Objects.equals(this.subscriptionId, cacheKey.subscriptionId);
        }

        public int hashCode() {
            return Objects.hash(this.credentialsId, this.subscriptionId);
        }
    }
}

