/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.Workflow;
import com.microsoft.graph.identitygovernance.requests.WorkflowCollectionPage;
import com.microsoft.graph.identitygovernance.requests.WorkflowCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.WorkflowRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowCollectionRequest
extends BaseEntityCollectionRequest<Workflow, WorkflowCollectionResponse, WorkflowCollectionPage> {
    public WorkflowCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkflowCollectionResponse.class, WorkflowCollectionPage.class, WorkflowCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Workflow> postAsync(@Nonnull Workflow newWorkflow) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkflowRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newWorkflow);
    }

    @Nonnull
    public Workflow post(@Nonnull Workflow newWorkflow) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkflowRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkflow);
    }

    @Nonnull
    public WorkflowCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public WorkflowCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

