/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.graph.core.DateOnly;
import com.microsoft.graph.core.TimeOfDay;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionResponse;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.ByteArraySerializer;
import com.microsoft.graph.serializer.CollectionPageSerializer;
import com.microsoft.graph.serializer.CollectionResponseDeserializer;
import com.microsoft.graph.serializer.EdmNativeTypeSerializer;
import com.microsoft.graph.serializer.EnumSetSerializer;
import com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import com.microsoft.graph.serializer.OffsetDateTimeSerializer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

final class GsonFactory {
    protected static String PARSING_MESSAGE = "Parsing issue on ";

    private GsonFactory() {
    }

    @Nonnull
    public static Gson getGsonInstance(@Nonnull ILogger logger) {
        return GsonFactory.getGsonInstance(logger, false);
    }

    @Nonnull
    public static Gson getGsonInstance(@Nonnull ILogger logger, boolean serializeNulls) {
        Objects.requireNonNull(logger, "parameter logger cannot be null");
        JsonSerializer calendarJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            try {
                return new JsonPrimitive(OffsetDateTimeSerializer.serialize(src));
            }
            catch (Exception e) {
                logger.logError(PARSING_MESSAGE + src, e);
                return null;
            }
        };
        JsonDeserializer calendarJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            try {
                return OffsetDateTimeSerializer.deserialize(json.getAsString());
            }
            catch (ParseException e) {
                logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                return null;
            }
        };
        JsonSerializer byteArrayJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            try {
                return new JsonPrimitive(ByteArraySerializer.serialize(src));
            }
            catch (Exception e) {
                logger.logError(PARSING_MESSAGE + Arrays.toString(src), e);
                return null;
            }
        };
        JsonDeserializer byteArrayJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            try {
                return ByteArraySerializer.deserialize(json.getAsString());
            }
            catch (ParseException e) {
                logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                return null;
            }
        };
        JsonSerializer dateJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null) {
                return null;
            }
            return new JsonPrimitive(src.toString());
        };
        JsonDeserializer dateJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            try {
                return DateOnly.parse(json.getAsString());
            }
            catch (ParseException e) {
                logger.logError(PARSING_MESSAGE + json.getAsString(), e);
                return null;
            }
        };
        EnumSetSerializer eSetSerializer = new EnumSetSerializer(logger);
        JsonSerializer enumSetJsonSerializer = (src, typeOfSrc, context) -> {
            if (src == null || src.isEmpty()) {
                return null;
            }
            return eSetSerializer.serialize((EnumSet<?>)src);
        };
        JsonDeserializer enumSetJsonDeserializer = (json, typeOfT, context) -> {
            if (json == null) {
                return null;
            }
            return eSetSerializer.deserialize(typeOfT, json.getAsString());
        };
        JsonSerializer durationJsonSerializer = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
        JsonDeserializer durationJsonDeserializer = (json, typeOfT, context) -> {
            try {
                return DatatypeFactory.newInstance().newDuration(json.getAsString());
            }
            catch (Exception e) {
                return null;
            }
        };
        JsonSerializer collectionPageSerializer = (src, typeOfSrc, context) -> CollectionPageSerializer.serialize(src, logger);
        JsonDeserializer collectionPageDeserializer = (json, typeOfT, context) -> CollectionPageSerializer.deserialize(json, typeOfT, logger);
        JsonDeserializer collectionResponseDeserializer = (json, typeOfT, context) -> CollectionResponseDeserializer.deserialize(json, typeOfT, logger);
        JsonDeserializer timeOfDayJsonDeserializer = (json, typeOfT, context) -> {
            try {
                return TimeOfDay.parse(json.getAsString());
            }
            catch (Exception e) {
                return null;
            }
        };
        JsonSerializer timeOfDayJsonSerializer = (src, typeOfSrc, context) -> new JsonPrimitive(src.toString());
        JsonDeserializer booleanJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Boolean.class, logger);
        JsonDeserializer stringJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, String.class, logger);
        JsonDeserializer bigDecimalJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, BigDecimal.class, logger);
        JsonDeserializer integerJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Integer.class, logger);
        JsonDeserializer longJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Long.class, logger);
        JsonDeserializer uuidJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, UUID.class, logger);
        JsonDeserializer floatJsonDeserializer = (json, typeOfT, context) -> EdmNativeTypeSerializer.deserialize(json, Float.class, logger);
        GsonBuilder builder = new GsonBuilder();
        if (serializeNulls) {
            builder.serializeNulls();
        }
        return builder.excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Boolean.class, (Object)booleanJsonDeserializer).registerTypeAdapter(String.class, (Object)stringJsonDeserializer).registerTypeAdapter(Float.class, (Object)floatJsonDeserializer).registerTypeAdapter(Integer.class, (Object)integerJsonDeserializer).registerTypeAdapter(BigDecimal.class, (Object)bigDecimalJsonDeserializer).registerTypeAdapter(UUID.class, (Object)uuidJsonDeserializer).registerTypeAdapter(Long.class, (Object)longJsonDeserializer).registerTypeAdapter(OffsetDateTime.class, (Object)calendarJsonSerializer).registerTypeAdapter(OffsetDateTime.class, (Object)calendarJsonDeserializer).registerTypeAdapter(GregorianCalendar.class, (Object)calendarJsonSerializer).registerTypeAdapter(GregorianCalendar.class, (Object)calendarJsonDeserializer).registerTypeAdapter(byte[].class, (Object)byteArrayJsonDeserializer).registerTypeAdapter(byte[].class, (Object)byteArrayJsonSerializer).registerTypeAdapter(DateOnly.class, (Object)dateJsonSerializer).registerTypeAdapter(DateOnly.class, (Object)dateJsonDeserializer).registerTypeAdapter(EnumSet.class, (Object)enumSetJsonSerializer).registerTypeAdapter(EnumSet.class, (Object)enumSetJsonDeserializer).registerTypeAdapter(Duration.class, (Object)durationJsonSerializer).registerTypeAdapter(Duration.class, (Object)durationJsonDeserializer).registerTypeHierarchyAdapter(BaseCollectionPage.class, (Object)collectionPageSerializer).registerTypeHierarchyAdapter(BaseCollectionPage.class, (Object)collectionPageDeserializer).registerTypeHierarchyAdapter(BaseCollectionResponse.class, (Object)collectionResponseDeserializer).registerTypeAdapter(TimeOfDay.class, (Object)timeOfDayJsonDeserializer).registerTypeAdapter(TimeOfDay.class, (Object)timeOfDayJsonSerializer).registerTypeAdapterFactory((TypeAdapterFactory)new FallbackTypeAdapterFactory(logger)).create();
    }
}

