/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.http.ICollectionResponse;
import com.microsoft.graph.options.Option;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseCollectionRequestBuilder<T, T2 extends BaseRequestBuilder<T>, T3 extends ICollectionResponse<T>, T4 extends BaseCollectionPage<T, ? extends BaseRequestBuilder<T>>, T5 extends BaseCollectionRequest<T, T3, T4>>
extends BaseRequestBuilder<T> {
    private final Class<T5> collRequestClass;
    private final Class<T2> reqBuilderClass;

    public BaseCollectionRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<T2> requestBuilderClass, @Nonnull Class<T5> collectionRequestClass) {
        super(requestUrl, client, requestOptions);
        this.collRequestClass = Objects.requireNonNull(collectionRequestClass, "parameter collectionRequestClass cannot be null");
        this.reqBuilderClass = Objects.requireNonNull(requestBuilderClass, "parameter requestBuilderClass cannot be null");
    }

    @Nonnull
    public T5 buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public T5 buildRequest(@Nullable List<? extends Option> requestOptions) {
        try {
            return (T5)((BaseCollectionRequest)this.collRequestClass.getConstructor(String.class, IBaseClient.class, List.class).newInstance(this.getRequestUrl(), this.getClient(), requestOptions));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ClientException("Could not find the required class", ex);
        }
    }

    @Nullable
    public T2 byId(@Nonnull String id) {
        Objects.requireNonNull(id, "parameter id cannot be null");
        try {
            return (T2)((BaseRequestBuilder)this.reqBuilderClass.getConstructor(String.class, IBaseClient.class, List.class).newInstance(this.getRequestUrlWithAdditionalSegment(id), this.getClient(), this.getOptions(new Option[0])));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new ClientException("Could not find the required class", ex);
        }
    }
}

