/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread.integrations.casc;

import com.microsoft.jenkins.azuread.AuthorizationContainer;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.Permission;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PermissionDefinition
implements Comparable<PermissionDefinition> {
    private final Permission permission;

    private PermissionDefinition(Permission permission) {
        this.permission = permission;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public static PermissionDefinition forPermission(Permission permission) {
        return new PermissionDefinition(permission);
    }

    public String toString() {
        return this.permission.group.getId() + "/" + this.permission.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionDefinition that = (PermissionDefinition)o;
        return Objects.equals(this.permission.toString(), that.permission.toString());
    }

    public int hashCode() {
        return Objects.hash(this.permission.toString());
    }

    @Override
    public int compareTo(@NonNull PermissionDefinition o) {
        return this.toString().compareTo(o.toString());
    }

    public static class StaplerConverterImpl
    implements Converter {
        public Object convert(Class target, Object o) {
            if (o == null) {
                return null;
            }
            if (target == PermissionDefinition.class && o instanceof List) {
                return ((List)o).stream().map(p -> (PermissionDefinition)p).map(p -> p.permission.group.getId() + "/" + p.permission.name).collect(Collectors.toList());
            }
            if (target == PermissionDefinition.class && o instanceof String) {
                return PermissionDefinition.forPermission(AuthorizationContainer.parsePermission((String)o));
            }
            throw new IllegalArgumentException("Failed to convert '" + String.valueOf(o) + "' to " + String.valueOf(target));
        }
    }
}

