/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread.avatar;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class EntraAvatarProperty
extends UserProperty
implements Action {
    private static final Logger LOGGER = Logger.getLogger(EntraAvatarProperty.class.getName());
    private final AvatarImage avatarImage;

    public EntraAvatarProperty(AvatarImage avatarImage) {
        this.avatarImage = avatarImage;
    }

    public String getAvatarUrl() {
        if (this.isHasAvatar()) {
            return this.getAvatarImageUrl();
        }
        return null;
    }

    private String getAvatarImageUrl() {
        return "%s%s/%s/image".formatted(Jenkins.get().getRootUrl(), this.user.getUrl(), this.getUrlName());
    }

    public boolean isHasAvatar() {
        return this.avatarImage != null && this.avatarImage.isValid();
    }

    public void doImage(StaplerRequest2 req, StaplerResponse2 rsp) {
        if (this.avatarImage == null) {
            LOGGER.log(Level.WARNING, "No image set for user '" + this.user.getId() + "'");
            return;
        }
        String imageFileName = "entra-avatar." + this.avatarImage.getFilenameSuffix();
        File file = new File(this.user.getUserFolder(), imageFileName);
        if (!file.exists()) {
            LOGGER.log(Level.WARNING, "Avatar image for user '" + this.user.getId() + "' does not exist");
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            rsp.setContentType(this.avatarImage.mimeType);
            rsp.serveFile(req, (InputStream)fileInputStream, file.lastModified(), file.length(), imageFileName);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to write image for user '" + this.user.getId() + "'", e);
        }
    }

    public String getDisplayName() {
        return "Entra Avatar";
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "entra-avatar";
    }

    public static class AvatarImage {
        private final String mimeType;

        public AvatarImage(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getFilenameSuffix() {
            return this.mimeType.split("/")[1].split("\\+")[0];
        }

        public boolean isValid() {
            return this.mimeType != null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends UserPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Entra Avatar";
        }

        public boolean isEnabled() {
            return false;
        }

        public UserProperty newInstance(User user) {
            return new EntraAvatarProperty(null);
        }
    }
}

