/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import java.util.HashMap;

public class ObjId2FullSidMap
extends HashMap<String, String> {
    public void putFullSid(String fullSid) {
        String objectId = ObjId2FullSidMap.extractObjectId(fullSid);
        if (objectId != null) {
            this.put(objectId, fullSid);
        }
    }

    public String getOrOriginal(String objectId) {
        if (this.containsKey(objectId)) {
            return (String)this.get(objectId);
        }
        String extractedObjectId = ObjId2FullSidMap.extractObjectId(objectId);
        if (this.containsKey(extractedObjectId)) {
            return (String)this.get(extractedObjectId);
        }
        String objValuesPrefix = objectId + " (";
        for (String value : this.values()) {
            if (!value.startsWith(objValuesPrefix)) continue;
            return value;
        }
        return objectId;
    }

    static String extractObjectId(String fullSid) {
        if (fullSid.isEmpty()) {
            return null;
        }
        if (fullSid.charAt(fullSid.length() - 1) != ')') {
            return null;
        }
        int openingParenthesesPosition = fullSid.lastIndexOf(40);
        if (openingParenthesesPosition <= 0) {
            return null;
        }
        if (fullSid.charAt(openingParenthesesPosition - 1) != ' ') {
            return null;
        }
        return fullSid.substring(openingParenthesesPosition + 1, fullSid.length() - 1);
    }

    static String generateFullSid(String displayName, String objectId) {
        return String.format("%s (%s)", displayName, objectId);
    }
}

