/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.httpcore.HttpClients;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.jenkins.azuread.AzureEnvironment;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import com.microsoft.jenkins.azuread.GraphClientCacheKey;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import jenkins.model.Jenkins;
import jenkins.util.JenkinsJVM;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;

public class GraphClientCache {
    private static final int TEN = 10;
    private static final LoadingCache<GraphClientCacheKey, GraphServiceClient<Request>> TOKEN_CACHE = Caffeine.newBuilder().maximumSize(10L).build(GraphClientCache::createGraphClient);

    private static GraphServiceClient<Request> createGraphClient(GraphClientCacheKey key) {
        TokenCredentialAuthProvider authProvider = GraphClientCache.getAuthProvider(key);
        OkHttpClient.Builder builder = HttpClients.createDefault((IAuthenticationProvider)authProvider).newBuilder();
        builder = GraphClientCache.addProxyToHttpClientIfRequired(builder, key.getAzureEnvironmentName());
        OkHttpClient graphHttpClient = builder.build();
        GraphServiceClient graphServiceClient = GraphServiceClient.builder().httpClient((Object)graphHttpClient).buildClient();
        String azureEnv = key.getAzureEnvironmentName();
        if (!azureEnv.equals("Azure")) {
            graphServiceClient.setServiceRoot(AzureEnvironment.getServiceRoot(azureEnv));
        }
        return graphServiceClient;
    }

    private static TokenCredentialAuthProvider getAuthProvider(GraphClientCacheKey key) {
        ClientSecretCredential tokenCredential;
        String graphResource = AzureEnvironment.getGraphResource(key.getAzureEnvironmentName());
        if ("Secret".equals(key.getCredentialType())) {
            tokenCredential = GraphClientCache.getClientSecretCredential(key);
        } else if ("Certificate".equals(key.getCredentialType())) {
            tokenCredential = GraphClientCache.getClientCertificateCredential(key);
        } else {
            throw new IllegalArgumentException("Invalid credential type");
        }
        return new TokenCredentialAuthProvider(Collections.singletonList(graphResource + ".default"), (TokenCredential)tokenCredential);
    }

    static ClientCertificateCredential getClientCertificateCredential(GraphClientCacheKey key) {
        return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(key.getClientId())).pemCertificate(GraphClientCache.getCertificate(key)).tenantId(key.getTenantId())).sendCertificateChain(true).authorityHost(AzureEnvironment.getAuthorityHost(key.getAzureEnvironmentName()))).httpClient(HttpClientRetriever.get())).build();
    }

    static ClientSecretCredential getClientSecretCredential(GraphClientCacheKey key) {
        return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(key.getClientId())).clientSecret(key.getClientSecret()).tenantId(key.getTenantId())).authorityHost(AzureEnvironment.getAuthorityHost(key.getAzureEnvironmentName()))).httpClient(HttpClientRetriever.get())).build();
    }

    static InputStream getCertificate(GraphClientCacheKey key) {
        String secretString = key.getClientCertificate();
        return new ByteArrayInputStream(secretString.getBytes(StandardCharsets.UTF_8));
    }

    static GraphServiceClient<Request> getClient(GraphClientCacheKey key) {
        return (GraphServiceClient)TOKEN_CACHE.get((Object)key);
    }

    public static GraphServiceClient<Request> getClient(AzureSecurityRealm azureSecurityRealm) {
        GraphClientCacheKey key = new GraphClientCacheKey(azureSecurityRealm.getClientId(), Secret.toString((Secret)azureSecurityRealm.getClientSecret()), Secret.toString((Secret)azureSecurityRealm.getClientCertificate()), azureSecurityRealm.getCredentialType(), azureSecurityRealm.getTenant(), azureSecurityRealm.getAzureEnvironmentName());
        return (GraphServiceClient)TOKEN_CACHE.get((Object)key);
    }

    public static OkHttpClient.Builder addProxyToHttpClientIfRequired(OkHttpClient.Builder builder, String azureEnvironmentName) {
        ProxyConfiguration proxyConfiguration;
        if (JenkinsJVM.isJenkinsJVM() && (proxyConfiguration = Jenkins.get().getProxy()) != null && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getName())) {
            String graphHost = URI.create(AzureEnvironment.getGraphResource(azureEnvironmentName)).getHost();
            Proxy proxy = proxyConfiguration.createProxy(graphHost);
            builder = builder.proxy(proxy);
            if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUserName())) {
                builder = builder.proxyAuthenticator((route, response) -> {
                    String credential = Credentials.basic((String)proxyConfiguration.getUserName(), (String)proxyConfiguration.getSecretPassword().getPlainText());
                    return response.request().newBuilder().header("Authorization", credential).build();
                });
            }
        }
        return builder;
    }
}

