/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.microsoft.jenkins.azuread.AbstractAuthorizationContainerConverter;
import com.microsoft.jenkins.azuread.AuthorizationContainer;
import com.microsoft.jenkins.azuread.AuthorizationContainerDescriptor;
import com.microsoft.jenkins.azuread.AuthorizationType;
import com.microsoft.jenkins.azuread.Messages;
import com.microsoft.jenkins.azuread.PermissionEntry;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.PluginManager;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionAdder;
import hudson.security.PermissionScope;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class GlobalMatrixAuthorizationStrategy
extends AuthorizationStrategy
implements AuthorizationContainer {
    private final transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<PermissionEntry>> grantedPermissions = new HashMap<Permission, Set<PermissionEntry>>();
    private final Set<String> groupSids = new HashSet<String>();
    @Restricted(value={NoExternalUse.class})
    public static final List<Permission> DANGEROUS_PERMISSIONS = Collections.unmodifiableList(Arrays.asList(Jenkins.RUN_SCRIPTS, PluginManager.CONFIGURE_UPDATECENTER, PluginManager.UPLOAD_PLUGINS));
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final Logger LOGGER = Logger.getLogger(GlobalMatrixAuthorizationStrategy.class.getName());

    @Override
    public Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries() {
        return this.grantedPermissions;
    }

    @Override
    public Permission getEditingPermission() {
        return Jenkins.ADMINISTER;
    }

    @NonNull
    public ACL getRootACL() {
        return this.acl;
    }

    @Override
    @NonNull
    public Set<String> getGroups() {
        TreeSet<String> sids = new TreeSet<String>(new AuthorizationContainer.IdStrategyComparator());
        sids.addAll(this.groupSids);
        return sids;
    }

    @Override
    public void recordGroup(String sid) {
        this.groupSids.add(sid);
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        protected Boolean hasPermission(Sid p, Permission permission) {
            if (GlobalMatrixAuthorizationStrategy.this.hasPermission(this.toString(p), permission, p instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }

    public static class DescriptorImpl
    extends Descriptor<AuthorizationStrategy>
    implements AuthorizationContainerDescriptor {
        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.JENKINS;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.GlobalMatrixAuthorizationStrategy_DisplayName();
        }

        public AuthorizationStrategy newInstance(StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            GlobalMatrixAuthorizationStrategy globalMatrixAuthorizationStrategy = this.create();
            JSONObject data = formData.getJSONObject("data");
            boolean adminAdded = false;
            for (Map.Entry r : data.entrySet()) {
                String permissionEntryString = (String)r.getKey();
                PermissionEntry entry = PermissionEntry.fromString(permissionEntryString);
                if (entry == null) {
                    LOGGER.log(Level.FINE, () -> "Failed to parse PermissionEntry from string: " + permissionEntryString);
                    continue;
                }
                if (!(r.getValue() instanceof JSONObject)) {
                    throw new Descriptor.FormException("not an object: " + String.valueOf(formData), "data");
                }
                JSONObject value = (JSONObject)r.getValue();
                for (Map.Entry e : value.entrySet()) {
                    if (!(e.getValue() instanceof Boolean)) {
                        throw new Descriptor.FormException("not an boolean: " + String.valueOf(formData), "data");
                    }
                    if (!((Boolean)e.getValue()).booleanValue()) continue;
                    Permission p = Permission.fromId((String)((String)e.getKey()));
                    if (p == null) {
                        LOGGER.log(Level.FINE, "Silently skip unknown permission \"{0}\" for sid:\"{1}\", type: {2}", new Object[]{e.getKey(), entry.getSid(), entry.getType()});
                        continue;
                    }
                    if (p == Jenkins.ADMINISTER) {
                        adminAdded = true;
                    }
                    globalMatrixAuthorizationStrategy.add(p, entry);
                }
            }
            if (!adminAdded) {
                User current = User.current();
                String id = current == null ? "anonymous" : current.getId();
                globalMatrixAuthorizationStrategy.add(Jenkins.ADMINISTER, new PermissionEntry(AuthorizationType.USER, id));
            }
            return globalMatrixAuthorizationStrategy;
        }

        protected GlobalMatrixAuthorizationStrategy create() {
            return new GlobalMatrixAuthorizationStrategy();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckName(@QueryParameter String value) {
            return this.doCheckName_(value, (AccessControlled)Jenkins.get(), Jenkins.ADMINISTER);
        }
    }

    @Restricted(value={DoNotUse.class})
    @Extension
    public static final class PermissionAdderImpl
    extends PermissionAdder {
        public boolean add(AuthorizationStrategy strategy, User user, Permission perm) {
            if (strategy instanceof GlobalMatrixAuthorizationStrategy) {
                ((GlobalMatrixAuthorizationStrategy)strategy).add(perm, PermissionEntry.user(user.getId()));
                try {
                    Jenkins.get().save();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, "Failed to save Jenkins after adding permission for user: " + user.getId(), ioe);
                }
                return true;
            }
            return false;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class ConverterImpl
    extends AbstractAuthorizationContainerConverter<GlobalMatrixAuthorizationStrategy> {
        @Override
        public boolean canConvert(Class type) {
            return type == GlobalMatrixAuthorizationStrategy.class;
        }

        @Override
        public GlobalMatrixAuthorizationStrategy create() {
            return new GlobalMatrixAuthorizationStrategy();
        }
    }
}

