/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenRequestContext;
import com.azure.identity.ClientCertificateCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.microsoft.graph.http.GraphServiceException;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.ProfilePhoto;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.GroupCollectionPage;
import com.microsoft.graph.requests.GroupCollectionRequest;
import com.microsoft.graph.requests.ProfilePhotoRequestBuilder;
import com.microsoft.jenkins.azuread.AzureAdGroup;
import com.microsoft.jenkins.azuread.AzureAdGroupDetails;
import com.microsoft.jenkins.azuread.AzureAdUser;
import com.microsoft.jenkins.azuread.AzureAuthenticationToken;
import com.microsoft.jenkins.azuread.AzureCachePool;
import com.microsoft.jenkins.azuread.AzureEnvironment;
import com.microsoft.jenkins.azuread.GraphClientCache;
import com.microsoft.jenkins.azuread.GraphClientCacheKey;
import com.microsoft.jenkins.azuread.ObjId2FullSidMap;
import com.microsoft.jenkins.azuread.Utils;
import com.microsoft.jenkins.azuread.avatar.EntraAvatarProperty;
import com.microsoft.jenkins.azuread.oauth.StateCache;
import com.microsoft.jenkins.azuread.scribe.AzureAdApi;
import com.microsoft.jenkins.azuread.utils.UUIDValidator;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.UserProperty;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException2;
import hudson.security.csrf.CrumbExclusion;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.azuresdk.HttpClientRetriever;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import jenkins.util.SystemProperties;
import okhttp3.Request;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class AzureSecurityRealm
extends SecurityRealm {
    public static final String REFERER_ATTRIBUTE = AzureSecurityRealm.class.getName() + ".referer";
    public static final String TIMESTAMP_ATTRIBUTE = AzureSecurityRealm.class.getName() + ".beginTime";
    public static final String NONCE_ATTRIBUTE = AzureSecurityRealm.class.getName() + ".nonce";
    private static final Logger LOGGER = Logger.getLogger(AzureSecurityRealm.class.getName());
    private static final int NONCE_LENGTH = 16;
    public static final String CALLBACK_URL = "/securityRealm/finishLogin";
    private static final String CONVERTER_NODE_CLIENT_ID = "clientid";
    private static final String CONVERTER_NODE_CLIENT_SECRET = "clientsecret";
    private static final String CONVERTER_NODE_CLIENT_CERTIFICATE = "clientCertificate";
    private static final String CONVERTER_NODE_CREDENTIAL_TYPE = "credentialType";
    private static final String CONVERTER_NODE_TENANT = "tenant";
    private static final String CONVERTER_NODE_CACHE_DURATION = "cacheduration";
    private static final String CONVERTER_NODE_FROM_REQUEST = "fromrequest";
    private static final int CACHE_KEY_LOG_LENGTH = 8;
    private static final int NOT_FOUND = 404;
    private static final int BAD_REQUEST = 400;
    public static final String CONVERTER_DISABLE_GRAPH_INTEGRATION = "disableGraphIntegration";
    public static final String CONVERTER_SINGLE_LOGOUT = "singleLogout";
    public static final String CONVERTER_PROMPT_ACCOUNT = "promptAccount";
    public static final String CONVERTER_DOMAIN_HINT = "domainHint";
    public static final String CONVERTER_ENVIRONMENT_NAME = "environmentName";
    private Cache<String, AzureAdUser> caches;
    private Secret clientId;
    private Secret clientSecret;
    private Secret clientCertificate;
    private Secret tenant;
    private int cacheDuration;
    private boolean fromRequest = false;
    private boolean promptAccount;
    private boolean singleLogout;
    private boolean disableGraphIntegration;
    private String azureEnvironmentName = "Azure";
    private String credentialType = "Secret";
    private String domainHint = "";
    private final Supplier<JwtConsumer> jwtConsumer = Suppliers.memoize(() -> Utils.JwtUtil.jwt(AzureEnvironment.getAuthorityHost(this.getAzureEnvironmentName()), this.getClientId(), this.getTenant()));

    public AccessToken getAccessToken() {
        TokenRequestContext tokenRequestContext = new TokenRequestContext();
        String graphResource = AzureEnvironment.getGraphResource(this.getAzureEnvironmentName());
        tokenRequestContext.setScopes(Collections.singletonList(graphResource + ".default"));
        AccessToken accessToken = (AccessToken)("Certificate".equals(this.credentialType) ? this.getClientCertificateCredential() : this.getClientSecretCredential()).getToken(tokenRequestContext).block();
        if (accessToken == null) {
            throw new IllegalStateException("Access token null when it is required");
        }
        return accessToken;
    }

    InputStream getCertificate() {
        String secretString = this.clientCertificate.getPlainText();
        return new ByteArrayInputStream(secretString.getBytes(StandardCharsets.UTF_8));
    }

    ClientSecretCredential getClientSecretCredential() {
        String azureEnv = this.getAzureEnvironmentName();
        return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId.getPlainText())).clientSecret(this.clientSecret.getPlainText()).tenantId(this.tenant.getPlainText())).authorityHost(AzureEnvironment.getAuthorityHost(azureEnv))).httpClient(HttpClientRetriever.get())).build();
    }

    ClientCertificateCredential getClientCertificateCredential() {
        String azureEnv = this.getAzureEnvironmentName();
        return ((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilder().clientId(this.clientId.getPlainText())).pemCertificate(this.getCertificate()).tenantId(this.tenant.getPlainText())).sendCertificateChain(true).authorityHost(AzureEnvironment.getAuthorityHost(azureEnv))).httpClient(HttpClientRetriever.get())).build();
    }

    public boolean isPromptAccount() {
        return this.promptAccount;
    }

    @DataBoundSetter
    public void setPromptAccount(boolean promptAccount) {
        this.promptAccount = promptAccount;
    }

    public String getDomainHint() {
        return this.domainHint;
    }

    @DataBoundSetter
    public void setDomainHint(String domainHint) {
        this.domainHint = domainHint;
    }

    public boolean isSingleLogout() {
        return this.singleLogout;
    }

    @DataBoundSetter
    public void setSingleLogout(boolean singleLogout) {
        this.singleLogout = singleLogout;
    }

    public String getClientIdSecret() {
        return this.clientId.getEncryptedValue();
    }

    public String getClientSecretSecret() {
        return this.clientSecret.getEncryptedValue();
    }

    public String getClientCertificateSecret() {
        return this.clientCertificate.getEncryptedValue();
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getTenantSecret() {
        return this.tenant.getEncryptedValue();
    }

    String getCredentialCacheKey() {
        String credentialComponent = this.clientId.getPlainText() + ("Certificate".equals(this.credentialType) ? this.clientCertificate.getPlainText() : this.clientSecret.getPlainText()) + this.tenant.getPlainText() + this.azureEnvironmentName;
        return Util.getDigestOf((String)credentialComponent);
    }

    public String getClientId() {
        return this.clientId.getPlainText();
    }

    public String getAzureEnvironmentName() {
        if (StringUtils.isBlank((CharSequence)this.azureEnvironmentName)) {
            return "Azure";
        }
        return this.azureEnvironmentName;
    }

    @DataBoundSetter
    public void setAzureEnvironmentName(String azureEnvironmentName) {
        this.azureEnvironmentName = azureEnvironmentName;
    }

    public boolean isDisableGraphIntegration() {
        return this.disableGraphIntegration;
    }

    @DataBoundSetter
    public void setDisableGraphIntegration(boolean disableGraphIntegration) {
        this.disableGraphIntegration = disableGraphIntegration;
    }

    @DataBoundSetter
    public void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }

    public void setClientId(String clientId) {
        this.clientId = Secret.fromString((String)clientId);
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public Secret getClientCertificate() {
        return this.clientCertificate;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = Secret.fromString((String)clientSecret);
    }

    @DataBoundSetter
    public void setClientCertificate(String clientCertificate) {
        this.clientCertificate = Secret.fromString((String)clientCertificate);
    }

    public String getTenant() {
        return this.tenant.getPlainText();
    }

    public void setTenant(String tenant) {
        this.tenant = Secret.fromString((String)tenant);
    }

    public int getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(int cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    public void setCaches(Cache<String, AzureAdUser> caches) {
        this.caches = caches;
    }

    public boolean isFromRequest() {
        return this.fromRequest;
    }

    @DataBoundSetter
    public void setFromRequest(boolean fromRequest) {
        this.fromRequest = fromRequest;
    }

    public JwtConsumer getJwtConsumer() {
        return (JwtConsumer)this.jwtConsumer.get();
    }

    OAuth20Service getOAuthService() {
        return new ServiceBuilder(this.clientId.getPlainText()).apiSecret("Certificate".equals(this.credentialType) ? this.clientCertificate.getPlainText() : this.clientSecret.getPlainText()).responseType("id_token").defaultScope("openid profile email").callback(this.getRootUrl() + CALLBACK_URL).build((DefaultApi20)AzureAdApi.custom(this.getTenant(), AzureEnvironment.getAuthorityHost(this.getAzureEnvironmentName())));
    }

    GraphServiceClient<Request> getAzureClient() {
        return GraphClientCache.getClient(this);
    }

    private String getRootUrl() {
        Jenkins jenkins = Jenkins.get();
        String url = this.isFromRequest() ? jenkins.getRootUrlFromRequest() : jenkins.getRootUrl();
        return StringUtils.stripEnd((String)url, (String)"/");
    }

    @DataBoundConstructor
    public AzureSecurityRealm(String tenant, String clientId, Secret clientSecret, int cacheDuration) {
        this.clientId = Secret.fromString((String)clientId);
        this.clientSecret = clientSecret;
        this.tenant = Secret.fromString((String)tenant);
        this.cacheDuration = cacheDuration;
        this.caches = Caffeine.newBuilder().expireAfterWrite((long)cacheDuration, TimeUnit.SECONDS).build();
    }

    public AzureSecurityRealm() {
        LOGGER.log(Level.FINE, "AzureSecurityRealm()");
    }

    public HttpResponse doCommenceLogin(StaplerRequest2 request, @Header(value="Referer") String referer) {
        String trimmedReferrer = AzureSecurityRealm.getReferer(referer);
        this.recreateSession(request);
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)trimmedReferrer);
        OAuth20Service service = this.getOAuthService();
        request.getSession().setAttribute(TIMESTAMP_ATTRIBUTE, (Object)System.currentTimeMillis());
        String nonce = RandomStringUtils.secure().nextAlphanumeric(16);
        request.getSession().setAttribute(NONCE_ATTRIBUTE, (Object)nonce);
        String state = new StateCache().generateValue(request.getSession());
        HashMap<String, String> additionalParams = new HashMap<String, String>();
        additionalParams.put("nonce", nonce);
        additionalParams.put("response_mode", "form_post");
        additionalParams.put("state", state);
        if (this.promptAccount) {
            additionalParams.put("prompt", "select_account");
        }
        if (!StringUtils.isBlank((CharSequence)this.domainHint)) {
            additionalParams.put("domain_hint", this.domainHint);
        }
        return new HttpRedirect(service.getAuthorizationUrl(additionalParams));
    }

    private static String getReferer(String referer) {
        String trimmedReferrer = referer;
        if (referer != null && referer.endsWith("azureAdLogout/")) {
            trimmedReferrer = referer.replace("azureAdLogout/", "");
        }
        return trimmedReferrer;
    }

    private void recreateSession(StaplerRequest2 request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        request.getSession(true);
    }

    public HttpResponse doFinishLogin(StaplerRequest2 request) throws InvalidJwtException, IOException {
        this.recreateSession(request);
        String state = request.getParameter("state");
        StateCache.CacheHolder cachedStateValue = (StateCache.CacheHolder)StateCache.CACHE.getIfPresent((Object)state);
        if (cachedStateValue == null || cachedStateValue.nonce() == null) {
            return HttpResponses.redirectToContextRoot();
        }
        String referer = cachedStateValue.referrer();
        try {
            Long beginTime = cachedStateValue.beginTime();
            String expectedNonce = cachedStateValue.nonce();
            long endTime = System.currentTimeMillis();
            LOGGER.info("Requesting oauth code time = " + (endTime - beginTime) + " ms");
            String idToken = request.getParameter("id_token");
            if (StringUtils.isBlank((CharSequence)idToken)) {
                LOGGER.info("No `id_token` found ensure you have enabled it on the 'Authentication' page of the app registration");
                return HttpResponses.redirectToContextRoot();
            }
            JwtClaims claims = this.validateIdToken(expectedNonce, idToken);
            String key = (String)claims.getClaimValue("oid");
            AzureAdUser userDetails = (AzureAdUser)this.caches.get((Object)key, cacheKey -> {
                AzureAdUser user = AzureAdUser.createFromJwt(claims);
                List<AzureAdGroup> groups = Collections.emptyList();
                if (!this.isDisableGraphIntegration()) {
                    groups = AzureCachePool.get(this.getAzureClient()).getBelongingGroupsByOid(user.getObjectID());
                }
                user.setAuthorities(groups, user.getUniqueName());
                LOGGER.info(String.format("Fetch user details with sub: %s***", key.substring(0, 8)));
                return user;
            });
            if (userDetails == null) {
                throw new IllegalStateException("Should not be possible");
            }
            AzureAuthenticationToken auth = new AzureAuthenticationToken(userDetails);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            hudson.model.User currentUser = hudson.model.User.current();
            if (currentUser == null) {
                throw new IllegalStateException("No current user after authentication");
            }
            this.updateIdentity(auth.getAzureAdUser(), currentUser);
            SecurityListener.fireAuthenticated2((UserDetails)userDetails);
            if (!this.isDisableGraphIntegration()) {
                this.updateAvatar(userDetails, currentUser);
            }
            SecurityListener.fireLoggedIn((String)currentUser.getId());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "error", ex);
            throw ex;
        }
        if (referer != null) {
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    private void updateAvatar(AzureAdUser userDetails, hudson.model.User currentUser) {
        block14: {
            if (currentUser == null) {
                return;
            }
            try {
                if (SystemProperties.getBoolean((String)(AzureSecurityRealm.class.getName() + ".disableAvatar"), (boolean)false)) {
                    return;
                }
                ProfilePhotoRequestBuilder photosRequestBuilder = this.getAzureClient().users(userDetails.getObjectID()).photos("48x48");
                LOGGER.finest("Fetching avatar metadata");
                ProfilePhoto profilePhoto = photosRequestBuilder.buildRequest(new Option[0]).get();
                LOGGER.finest("Completed fetching avatar metadata");
                if (profilePhoto != null) {
                    LOGGER.finest("Fetching avatar");
                    try (InputStream inputStream = photosRequestBuilder.content().buildRequest(new Option[0]).get();){
                        if (inputStream != null) {
                            String mediaContentType = ((JsonElement)profilePhoto.additionalDataManager().get((Object)"@odata.mediaContentType")).getAsString();
                            EntraAvatarProperty.AvatarImage avatarImage = new EntraAvatarProperty.AvatarImage(mediaContentType);
                            EntraAvatarProperty entraAvatarProperty = new EntraAvatarProperty(avatarImage);
                            File targetFile = new File(currentUser.getUserFolder(), "entra-avatar." + avatarImage.getFilenameSuffix());
                            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            currentUser.addProperty((UserProperty)entraAvatarProperty);
                            LOGGER.finest("Saved avatar");
                        }
                        break block14;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to save profile photo for %s".formatted(currentUser.getId()), e);
                    }
                    break block14;
                }
                LOGGER.finest("No avatar found");
            }
            catch (GraphServiceException e) {
                LOGGER.log(e.getResponseCode() == 404 ? Level.FINER : Level.WARNING, "Failed to get profile photo for %s".formatted(currentUser.getId()), e);
            }
        }
    }

    JwtClaims validateIdToken(String expectedNonce, String idToken) throws InvalidJwtException {
        JwtClaims claims = this.getJwtConsumer().processToClaims(idToken);
        String responseNonce = (String)claims.getClaimValue("nonce");
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{expectedNonce, responseNonce}) || !MessageDigest.isEqual(expectedNonce.getBytes(StandardCharsets.UTF_8), responseNonce.getBytes(StandardCharsets.UTF_8))) {
            throw new IllegalStateException(String.format("Invalid nonce in the response, expected: %s actual: %s", expectedNonce, responseNonce));
        }
        return claims;
    }

    protected String getPostLogOutUrl2(StaplerRequest2 req, Authentication auth) {
        if (auth instanceof AzureAuthenticationToken) {
            AzureAuthenticationToken azureToken = (AzureAuthenticationToken)auth;
            String oid = azureToken.getAzureAdUser().getObjectID();
            AzureCachePool.invalidateBelongingGroupsByOid(oid);
        }
        if (this.singleLogout) {
            return ((AzureAdApi)this.getOAuthService().getApi()).getLogoutUrl();
        }
        return req.getContextPath() + "/azureAdLogout";
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(authentication -> {
            if (authentication instanceof AzureAuthenticationToken) {
                return authentication;
            }
            throw new BadCredentialsException("Unexpected authentication type: " + String.valueOf(authentication));
        }, username -> {
            if (username == null) {
                throw new UserMayOrMayNotExistException2("Can't find a user with no username");
            }
            if (this.isDisableGraphIntegration()) {
                throw new UserMayOrMayNotExistException2("Can't lookup a user if graph integration is disabled");
            }
            AzureAdUser azureAdUser = (AzureAdUser)this.caches.get((Object)username, cacheKey -> {
                GraphServiceClient<Request> azureClient = this.getAzureClient();
                String userId = ObjId2FullSidMap.extractObjectId(username);
                if (userId == null) {
                    userId = username;
                }
                try {
                    User activeDirectoryUser = azureClient.users(userId).buildRequest(new Option[0]).get();
                    if (activeDirectoryUser != null & activeDirectoryUser.id == null) {
                        return null;
                    }
                    AzureAdUser user = Objects.requireNonNull(AzureAdUser.createFromActiveDirectoryUser(activeDirectoryUser));
                    List<AzureAdGroup> groups = AzureCachePool.get(azureClient).getBelongingGroupsByOid(user.getObjectID());
                    user.setAuthorities(groups, user.getUniqueName());
                    this.updateIdentity(user, AzureSecurityRealm.getByIdOrCreate(user));
                    return user;
                }
                catch (GraphServiceException e) {
                    if (e.getResponseCode() == 404) {
                        return null;
                    }
                    if (e.getResponseCode() == 400) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Failed to lookup user with userid '" + userId, e);
                        } else {
                            LOGGER.log(Level.WARNING, "Failed to lookup user with userid '" + userId + "'. Enable 'Fine' Logging for more information.");
                        }
                        return null;
                    }
                    throw e;
                }
            });
            if (azureAdUser == null) {
                throw new UsernameNotFoundException("Cannot find user: " + username);
            }
            return azureAdUser;
        });
    }

    @NonNull
    private static hudson.model.User getByIdOrCreate(AzureAdUser user) {
        hudson.model.User byId = hudson.model.User.getById((String)user.getObjectID(), (boolean)true);
        if (byId == null) {
            throw new IllegalStateException("User should have been created but is null");
        }
        return byId;
    }

    public GroupDetails loadGroupByGroupname2(String groupName, boolean fetchMembers) {
        Group group;
        if (this.isDisableGraphIntegration()) {
            throw new UserMayOrMayNotExistException2("Can't lookup a group if graph integration is disabled");
        }
        GraphServiceClient<Request> azureClient = this.getAzureClient();
        String groupId = ObjId2FullSidMap.extractObjectId(groupName);
        if (groupId == null) {
            groupId = groupName;
        }
        if ((group = UUIDValidator.isValidUUID(groupId) ? azureClient.groups(groupId).buildRequest(new Option[0]).get() : this.loadGroupByDisplayName(groupName)) == null || group.id == null) {
            throw new UsernameNotFoundException("Group: " + groupName + " not found");
        }
        return new AzureAdGroupDetails(group.id, group.displayName);
    }

    @CheckForNull
    private Group loadGroupByDisplayName(String groupName) {
        LinkedList<QueryOption> requestOptions = new LinkedList<QueryOption>();
        String encodedGroupName = groupName.replace("'", "''");
        encodedGroupName = URLEncoder.encode(encodedGroupName, StandardCharsets.UTF_8);
        String query = String.format("displayName eq '%s'", encodedGroupName);
        requestOptions.add(new QueryOption("$filter", (Object)query));
        GroupCollectionPage groupCollectionPage = (GroupCollectionPage)((GroupCollectionRequest)this.getAzureClient().groups().buildRequest(requestOptions)).select("id,displayName").get();
        assert (groupCollectionPage != null);
        List currentPage = groupCollectionPage.getCurrentPage();
        Group group = null;
        if (currentPage.size() > 1) {
            String groupIds = currentPage.stream().map(groupO -> groupO.id).collect(Collectors.joining(","));
            throw new UsernameNotFoundException("Multiple matches found for group display name, this must be unique: " + groupIds);
        }
        if (currentPage.size() == 1) {
            group = (Group)currentPage.get(0);
        }
        return group;
    }

    public boolean allowsSignup() {
        return false;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    private void updateIdentity(AzureAdUser azureAdUser, @NonNull hudson.model.User u) {
        if (azureAdUser != null) {
            try {
                Mailer.UserProperty existing;
                String description = this.generateDescription(azureAdUser);
                u.setDescription(description);
                u.setFullName(azureAdUser.getName());
                if (StringUtils.isNotBlank((CharSequence)azureAdUser.getEmail()) && ((existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)) == null || !existing.hasExplicitlyConfiguredAddress())) {
                    u.addProperty((UserProperty)new Mailer.UserProperty(azureAdUser.getEmail()));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to update user mail with userid: " + azureAdUser.getObjectID(), e);
            }
        }
    }

    private String generateDescription(AzureAdUser user) {
        return "Entra ID User\n\nUnique Principal Name: " + user.getUniqueName() + "\nEmail: " + user.getEmail() + "\nObject ID: " + user.getObjectID() + "\nTenant ID: " + user.getTenantID();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        @NonNull
        public String getDisplayName() {
            return "Entra ID";
        }

        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }

        public ListBoxModel doFillAzureEnvironmentNameItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("Azure");
            model.add("Azure China");
            model.add("Azure US Government L4");
            model.add("Azure US Government L5 (DOD)");
            return model;
        }

        public FormValidation doVerifyConfiguration(@QueryParameter String clientId, @QueryParameter Secret clientSecret, @QueryParameter Secret clientCertificate, @QueryParameter String credentialType, @QueryParameter String tenant, @QueryParameter String testObject, @QueryParameter String azureEnvironmentName) {
            switch (credentialType) {
                case "Secret": {
                    if (!Secret.toString((Secret)clientSecret).isEmpty()) break;
                    return FormValidation.error((String)"Please set a secret");
                }
                case "Certificate": {
                    if (!Secret.toString((Secret)clientCertificate).isEmpty()) break;
                    return FormValidation.error((String)"Please set a certificate");
                }
                default: {
                    return FormValidation.error((String)"Invalid credential type");
                }
            }
            if (testObject.isEmpty()) {
                return FormValidation.error((String)"Please set a test user principal name or object ID");
            }
            GraphServiceClient<Request> graphServiceClient = GraphClientCache.getClient(new GraphClientCacheKey(clientId, Secret.toString((Secret)clientSecret), Secret.toString((Secret)clientCertificate), credentialType, tenant, azureEnvironmentName));
            try {
                User user = graphServiceClient.users(testObject).buildRequest(new Option[0]).get();
                return FormValidation.ok((String)("Successfully verified, found display name: " + user.displayName));
            }
            catch (Exception ex) {
                return FormValidation.error((Throwable)ex, (String)ex.getMessage());
            }
        }
    }

    @Extension
    public static final class CrumbExempt
    extends CrumbExclusion {
        public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            String pathInfo = request.getPathInfo();
            if (pathInfo != null && pathInfo.equals(AzureSecurityRealm.CALLBACK_URL)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == AzureSecurityRealm.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            AzureSecurityRealm realm = (AzureSecurityRealm)((Object)source);
            writer.startNode(AzureSecurityRealm.CONVERTER_NODE_CLIENT_ID);
            writer.setValue(realm.getClientIdSecret());
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_NODE_CREDENTIAL_TYPE);
            writer.setValue(realm.getCredentialType());
            writer.endNode();
            if ("Secret".equals(realm.getCredentialType())) {
                writer.startNode(AzureSecurityRealm.CONVERTER_NODE_CLIENT_SECRET);
                writer.setValue(realm.getClientSecretSecret());
                writer.endNode();
            } else {
                writer.startNode(AzureSecurityRealm.CONVERTER_NODE_CLIENT_CERTIFICATE);
                writer.setValue(realm.getClientCertificateSecret());
                writer.endNode();
            }
            writer.startNode(AzureSecurityRealm.CONVERTER_NODE_TENANT);
            writer.setValue(realm.getTenantSecret());
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_NODE_CACHE_DURATION);
            writer.setValue(String.valueOf(realm.getCacheDuration()));
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_NODE_FROM_REQUEST);
            writer.setValue(String.valueOf(realm.isFromRequest()));
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_ENVIRONMENT_NAME);
            writer.setValue(String.valueOf(realm.getAzureEnvironmentName()));
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_DISABLE_GRAPH_INTEGRATION);
            writer.setValue(String.valueOf(realm.isDisableGraphIntegration()));
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_PROMPT_ACCOUNT);
            writer.setValue(String.valueOf(realm.isPromptAccount()));
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_SINGLE_LOGOUT);
            writer.setValue(String.valueOf(realm.isSingleLogout()));
            writer.endNode();
            writer.startNode(AzureSecurityRealm.CONVERTER_DOMAIN_HINT);
            writer.setValue(String.valueOf(realm.getDomainHint()));
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            AzureSecurityRealm realm = new AzureSecurityRealm();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String node = reader.getNodeName();
                String value = reader.getValue();
                switch (node) {
                    case "clientid": {
                        realm.setClientId(value);
                        break;
                    }
                    case "clientsecret": {
                        realm.setClientSecret(value);
                        break;
                    }
                    case "clientCertificate": {
                        realm.setClientCertificate(value);
                        break;
                    }
                    case "credentialType": {
                        realm.setCredentialType(value);
                        break;
                    }
                    case "tenant": {
                        realm.setTenant(value);
                        break;
                    }
                    case "cacheduration": {
                        realm.setCacheDuration(Integer.parseInt(value));
                        break;
                    }
                    case "fromrequest": {
                        realm.setFromRequest(Boolean.parseBoolean(value));
                        break;
                    }
                    case "environmentName": {
                        realm.setAzureEnvironmentName(value);
                        break;
                    }
                    case "disableGraphIntegration": {
                        realm.setDisableGraphIntegration(Boolean.parseBoolean(value));
                        break;
                    }
                    case "promptAccount": {
                        realm.setPromptAccount(Boolean.parseBoolean(value));
                        break;
                    }
                    case "singleLogout": {
                        realm.setSingleLogout(Boolean.parseBoolean(value));
                        break;
                    }
                    case "domainHint": {
                        realm.setDomainHint(value);
                        break;
                    }
                }
                reader.moveUp();
            }
            Cache caches = Caffeine.newBuilder().expireAfterWrite((long)realm.getCacheDuration(), TimeUnit.SECONDS).build();
            realm.setCaches((Cache<String, AzureAdUser>)caches);
            return realm;
        }
    }
}

