/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.microsoft.jenkins.azuread.AbstractAuthorizationPropertyConverter;
import com.microsoft.jenkins.azuread.AuthorizationMatrixProperty;
import com.microsoft.jenkins.azuread.AuthorizationProperty;
import com.microsoft.jenkins.azuread.AuthorizationPropertyDescriptor;
import com.microsoft.jenkins.azuread.AzureAdMatrixAuthorizationStrategy;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import com.microsoft.jenkins.azuread.ObjId2FullSidMap;
import com.microsoft.jenkins.azuread.PermissionEntry;
import com.microsoft.jenkins.azuread.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritGlobalStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.GET;

public class AzureAdAuthorizationMatrixProperty
extends AuthorizationMatrixProperty {
    private final transient ObjId2FullSidMap objId2FullSidMap = new ObjId2FullSidMap();

    public AzureAdAuthorizationMatrixProperty() {
        super(Collections.emptyList());
    }

    public AzureAdAuthorizationMatrixProperty(Map<Permission, Set<PermissionEntry>> grantedPermissions, InheritanceStrategy inheritanceStrategy) {
        super(grantedPermissions, (InheritanceStrategy)new InheritGlobalStrategy());
        this.refreshMap();
    }

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public AzureAdAuthorizationMatrixProperty(List<AuthorizationProperty.DslEntry> entries) {
        this();
        this.setEntries(entries);
    }

    void refreshMap() {
        for (PermissionEntry entry : this.getAllPermissionEntries()) {
            this.objId2FullSidMap.putFullSid(entry.getSid());
        }
        new AzureAdAuthorizationMatrixProperty();
    }

    @Override
    public void add(Permission p, PermissionEntry entry) {
        super.add(p, entry);
        this.objId2FullSidMap.putFullSid(entry.getSid());
    }

    @Override
    public boolean hasExplicitPermission(PermissionEntry entry, Permission p) {
        String objectId = entry.getSid();
        if (objectId == null) {
            return false;
        }
        PermissionEntry entry1 = new PermissionEntry(entry.getType(), this.objId2FullSidMap.getOrOriginal(objectId));
        return super.hasExplicitPermission(entry1, p);
    }

    @Override
    public boolean hasPermission(String sid, Permission p, boolean principal) {
        return super.hasPermission(this.objId2FullSidMap.getOrOriginal(sid), p, principal);
    }

    public static class ConverterImpl
    extends AbstractAuthorizationPropertyConverter {
        @Override
        public boolean canConvert(Class type) {
            return type == AzureAdAuthorizationMatrixProperty.class;
        }

        @Override
        public AuthorizationProperty create() {
            return new AzureAdAuthorizationMatrixProperty();
        }
    }

    @Extension
    @Symbol(value={"azureAdAuthorizationMatrix"})
    public static class DescriptorImpl
    extends JobPropertyDescriptor
    implements AuthorizationPropertyDescriptor<AzureAdAuthorizationMatrixProperty> {
        @Override
        public AzureAdAuthorizationMatrixProperty create() {
            return new AzureAdAuthorizationMatrixProperty();
        }

        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.ITEM;
        }

        public JobProperty<?> newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (JobProperty)this.createNewInstance(req, formData, true);
        }

        @Override
        public boolean isApplicable() {
            return Jenkins.get().getAuthorizationStrategy() instanceof AzureAdMatrixAuthorizationStrategy;
        }

        @GET
        public FormValidation doCheckName(@AncestorInPath Job<?, ?> project, @QueryParameter String value) {
            if (this.isDisableGraphIntegration()) {
                return Utils.undecidableResponse(value);
            }
            if (project == null) {
                return Utils.undecidableResponse(value);
            }
            return this.doCheckName_(value, (AccessControlled)project, Item.CONFIGURE);
        }

        @NonNull
        public String getDisplayName() {
            return "Entra ID Authorization Matrix";
        }

        public boolean isDisableGraphIntegration() {
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            if (securityRealm instanceof AzureSecurityRealm) {
                AzureSecurityRealm azureSecurityRealm = (AzureSecurityRealm)securityRealm;
                return azureSecurityRealm.isDisableGraphIntegration();
            }
            return true;
        }
    }
}

