/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.microsoft.jenkins.azuread.AbstractAuthorizationPropertyConverter;
import com.microsoft.jenkins.azuread.AuthorizationProperty;
import com.microsoft.jenkins.azuread.AuthorizationPropertyDescriptor;
import com.microsoft.jenkins.azuread.AzureAdMatrixAuthorizationStrategy;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import com.microsoft.jenkins.azuread.ObjId2FullSidMap;
import com.microsoft.jenkins.azuread.PermissionEntry;
import com.microsoft.jenkins.azuread.Utils;
import com.microsoft.jenkins.azuread.folder.properties.AuthorizationMatrixProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.GET;

public class AzureAdAuthorizationMatrixFolderProperty
extends AuthorizationMatrixProperty {
    private final transient ObjId2FullSidMap objId2FullSidMap = new ObjId2FullSidMap();

    protected AzureAdAuthorizationMatrixFolderProperty() {
    }

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public AzureAdAuthorizationMatrixFolderProperty(List<AuthorizationProperty.DslEntry> entries) {
        this.setEntries(entries);
    }

    @Override
    public void add(Permission permission, PermissionEntry entry) {
        super.add(permission, entry);
        this.objId2FullSidMap.putFullSid(entry.getSid());
    }

    @Override
    public boolean hasExplicitPermission(PermissionEntry entry, Permission p) {
        String objectId = entry.getSid();
        if (objectId == null) {
            return false;
        }
        String fullSid = this.objId2FullSidMap.getOrOriginal(objectId);
        return super.hasExplicitPermission(new PermissionEntry(entry.getType(), fullSid), p);
    }

    @Override
    public boolean hasPermission(String sid, Permission p, boolean principal) {
        String fullSid = this.objId2FullSidMap.getOrOriginal(sid);
        return super.hasPermission(fullSid, p, principal);
    }

    public static class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AzureAdAuthorizationMatrixFolderProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AzureAdAuthorizationMatrixFolderProperty.class;
        }

        @Override
        public AzureAdAuthorizationMatrixFolderProperty create() {
            return new AzureAdAuthorizationMatrixFolderProperty();
        }
    }

    @Extension(optional=true)
    @Symbol(value={"azureAdAuthorizationMatrix"})
    public static class DescriptorImpl
    extends AbstractFolderPropertyDescriptor
    implements AuthorizationPropertyDescriptor<AzureAdAuthorizationMatrixFolderProperty> {
        @Override
        public AzureAdAuthorizationMatrixFolderProperty create() {
            return new AzureAdAuthorizationMatrixFolderProperty();
        }

        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.ITEM_GROUP;
        }

        public AuthorizationMatrixProperty newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (AuthorizationMatrixProperty)this.createNewInstance(req, formData, true);
        }

        @Override
        public boolean isApplicable() {
            return Jenkins.get().getAuthorizationStrategy() instanceof AzureAdMatrixAuthorizationStrategy;
        }

        @GET
        public FormValidation doCheckName(@AncestorInPath AbstractFolder<?> folder, @QueryParameter String value) {
            if (this.isDisableGraphIntegration()) {
                return Utils.undecidableResponse(value);
            }
            return this.doCheckName_(value, (AccessControlled)folder, Item.CONFIGURE);
        }

        public boolean isDisableGraphIntegration() {
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            if (securityRealm instanceof AzureSecurityRealm) {
                AzureSecurityRealm azureSecurityRealm = (AzureSecurityRealm)securityRealm;
                return azureSecurityRealm.isDisableGraphIntegration();
            }
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Entra ID Authorization Matrix";
        }

        public AutoCompletionCandidates doAutoCompleteUserOrGroup(@QueryParameter String value) {
            return AzureAdMatrixAuthorizationStrategy.searchAndGenerateCandidates(value);
        }
    }
}

