/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.microsoft.jenkins.azuread.AbstractAuthorizationPropertyConverter;
import com.microsoft.jenkins.azuread.AuthorizationProperty;
import com.microsoft.jenkins.azuread.AuthorizationPropertyDescriptor;
import com.microsoft.jenkins.azuread.Messages;
import com.microsoft.jenkins.azuread.PermissionEntry;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SidACL;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import net.sf.json.JSONObject;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritGlobalStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class AuthorizationMatrixNodeProperty
extends NodeProperty<Node>
implements AuthorizationProperty {
    private final transient SidACL acl = new AclImpl();
    private final Map<Permission, Set<PermissionEntry>> grantedPermissions = new HashMap<Permission, Set<PermissionEntry>>();
    private final Set<String> groupSids = new HashSet<String>();
    @Deprecated
    private transient Boolean blocksInheritance;
    private InheritanceStrategy inheritanceStrategy = new InheritGlobalStrategy();
    private static final Logger LOGGER = Logger.getLogger(AuthorizationMatrixNodeProperty.class.getName());

    @Restricted(value={NoExternalUse.class})
    public AuthorizationMatrixNodeProperty() {
    }

    public AuthorizationMatrixNodeProperty(Map<Permission, Set<PermissionEntry>> grantedPermissions) {
        for (Map.Entry<Permission, Set<PermissionEntry>> e : grantedPermissions.entrySet()) {
            this.grantedPermissions.put(e.getKey(), new HashSet(e.getValue()));
        }
    }

    @Override
    public Set<String> getGroups() {
        return this.groupSids;
    }

    @Override
    public void recordGroup(String sid) {
        this.groupSids.add(sid);
    }

    @Override
    public Map<Permission, Set<PermissionEntry>> getGrantedPermissionEntries() {
        return this.grantedPermissions;
    }

    @Override
    public Permission getEditingPermission() {
        return Computer.CONFIGURE;
    }

    @Override
    public void setInheritanceStrategy(InheritanceStrategy inheritanceStrategy) {
        this.inheritanceStrategy = inheritanceStrategy;
    }

    @Override
    public InheritanceStrategy getInheritanceStrategy() {
        return this.inheritanceStrategy;
    }

    public SidACL getACL() {
        return this.acl;
    }

    private final class AclImpl
    extends SidACL {
        private AclImpl() {
        }

        @CheckForNull
        protected Boolean hasPermission(Sid sid, Permission p) {
            if (AuthorizationMatrixNodeProperty.this.hasPermission(this.toString(sid), p, sid instanceof PrincipalSid)) {
                return true;
            }
            return null;
        }
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class NodeListenerImpl
    extends NodeListener {
        protected void onCreated(@NonNull Node node) {
            AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
            if (authorizationStrategy instanceof ProjectMatrixAuthorizationStrategy) {
                User current;
                String sid;
                ProjectMatrixAuthorizationStrategy strategy = (ProjectMatrixAuthorizationStrategy)authorizationStrategy;
                AuthorizationMatrixNodeProperty prop = (AuthorizationMatrixNodeProperty)node.getNodeProperty(AuthorizationMatrixNodeProperty.class);
                if (prop == null) {
                    prop = new AuthorizationMatrixNodeProperty();
                }
                String string = sid = (current = User.current()) == null ? "anonymous" : current.getId();
                if (!strategy.getACL(node).hasPermission2(Jenkins.getAuthentication2(), Computer.CONFIGURE)) {
                    prop.add(Computer.CONFIGURE, PermissionEntry.user(sid));
                }
                if (!prop.getGrantedPermissionEntries().isEmpty()) {
                    try {
                        node.getNodeProperties().replace((Describable)prop);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Failed to grant creator permissions on node " + node.getDisplayName(), ex);
                    }
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends NodePropertyDescriptor
    implements AuthorizationPropertyDescriptor<AuthorizationMatrixNodeProperty> {
        @Override
        @Restricted(value={NoExternalUse.class})
        public AuthorizationMatrixNodeProperty create() {
            return new AuthorizationMatrixNodeProperty();
        }

        @Override
        @Restricted(value={NoExternalUse.class})
        public PermissionScope getPermissionScope() {
            return PermissionScope.COMPUTER;
        }

        public AuthorizationMatrixNodeProperty newInstance(StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            return (AuthorizationMatrixNodeProperty)this.createNewInstance(req, formData, false);
        }

        public boolean isApplicable(Class<? extends Node> node) {
            return this.isApplicable();
        }

        @NonNull
        public String getDisplayName() {
            return Messages.AuthorizationMatrixNodeProperty_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckName(@AncestorInPath Computer computer, @QueryParameter String value) {
            return this.doCheckName_(value, (AccessControlled)(computer == null ? Jenkins.get() : computer), computer == null ? Jenkins.ADMINISTER : Computer.CONFIGURE);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AuthorizationMatrixNodeProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AuthorizationMatrixNodeProperty.class;
        }

        @Override
        public AuthorizationMatrixNodeProperty create() {
            return new AuthorizationMatrixNodeProperty();
        }
    }
}

