/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.TokenLifetimePolicy;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TokenLifetimePolicyReferenceRequest
extends BaseReferenceRequest<TokenLifetimePolicy> {
    public TokenLifetimePolicyReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenLifetimePolicy.class);
    }

    @Nonnull
    public TokenLifetimePolicyReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public TokenLifetimePolicyReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<TokenLifetimePolicy> putAsync(@Nonnull TokenLifetimePolicy srcTokenLifetimePolicy) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/policies/tokenLifetimePolicies/" + srcTokenLifetimePolicy.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public TokenLifetimePolicy put(@Nonnull TokenLifetimePolicy srcTokenLifetimePolicy) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/policies/tokenLifetimePolicies/" + srcTokenLifetimePolicy.id));
        return (TokenLifetimePolicy)this.send(HttpMethod.PUT, payload);
    }
}

