/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.azure.core.credential.AccessToken;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.microsoft.jenkins.azuread.AzureAuthenticationToken;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import com.microsoft.jenkins.azuread.GraphClientCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.RootAction;
import hudson.security.AccessControlled;
import hudson.security.SecurityRealm;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.TransientActionFactory;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Extension
@Restricted(value={NoExternalUse.class})
public class GraphProxy
implements RootAction,
StaplerProxy {
    private static final int TEN = 10;
    private final Cache<String, AccessToken> tokenCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();
    private AccessControlled accessControlled;
    private static final OkHttpClient DEFAULT_CLIENT = new OkHttpClient();

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "GraphProxy";
    }

    public GraphProxy() {
    }

    public GraphProxy(AccessControlled accessControlled) {
        this.accessControlled = accessControlled;
    }

    public Object getTarget() {
        if (this.accessControlled != null) {
            if (this.accessControlled instanceof AbstractItem) {
                this.accessControlled.checkPermission(AbstractItem.CONFIGURE);
            } else if (this.accessControlled instanceof Computer) {
                this.accessControlled.checkPermission(Computer.CONFIGURE);
            } else {
                this.accessControlled.checkPermission(Jenkins.ADMINISTER);
            }
            return this;
        }
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    public void doDynamic(StaplerRequest2 request, StaplerResponse2 response) throws IOException {
        this.proxy(request, response);
    }

    private void proxy(StaplerRequest2 request, StaplerResponse2 response) throws IOException {
        OkHttpClient client = this.getClient();
        String baseUrl = this.getBaseUrl();
        String token = this.getToken();
        String url = this.buildUrl(request, baseUrl);
        Request okRequest = this.buildRequest(request, token, url);
        try (Response okResp = client.newCall(okRequest).execute();){
            String contentType = okResp.header("Content-Type", "application/json");
            response.setContentType(contentType);
            response.setStatus(okResp.code());
            response.addHeader("request-id", okResp.header("request-id"));
            response.addHeader("client-request-id", okResp.header("client-request-id"));
            ResponseBody body = okResp.body();
            if (body != null) {
                if (contentType.startsWith("application/json")) {
                    String string = body.string();
                    response.getWriter().write(string);
                } else {
                    response.getWriter().write(body.byteString().string(StandardCharsets.ISO_8859_1));
                }
            }
        }
    }

    private OkHttpClient getClient() {
        ProxyConfiguration proxyConfiguration = Jenkins.get().getProxy();
        if (proxyConfiguration != null && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getName())) {
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            AzureSecurityRealm azureSecurityRealm = (AzureSecurityRealm)securityRealm;
            String azureEnvironmentName = azureSecurityRealm.getAzureEnvironmentName();
            return GraphClientCache.addProxyToHttpClientIfRequired(new OkHttpClient().newBuilder(), azureEnvironmentName).build();
        }
        return DEFAULT_CLIENT;
    }

    private String getToken() {
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        if (securityRealm instanceof AzureSecurityRealm) {
            AzureSecurityRealm azureSecurityRealm = (AzureSecurityRealm)securityRealm;
            String cacheKey = azureSecurityRealm.getCredentialCacheKey();
            AccessToken accessToken = (AccessToken)this.tokenCache.get((Object)cacheKey, unused -> azureSecurityRealm.getAccessToken());
            if (accessToken == null) {
                throw new IllegalStateException("Access token must not be null here");
            }
            return accessToken.getToken();
        }
        throw new IllegalStateException("GraphProxy only works when Authentication is set to Azure");
    }

    private String getBaseUrl() {
        SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
        if (securityRealm instanceof AzureSecurityRealm) {
            return ((AzureSecurityRealm)securityRealm).getAzureClient().getServiceRoot();
        }
        throw new IllegalStateException("GraphProxy only works when Authentication is set to Azure");
    }

    private Request buildRequest(StaplerRequest2 request, String token, String url) throws IOException {
        String ifMatch;
        String accept;
        Request.Builder okRequest = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + token);
        String consistencyLevel = request.getHeader("ConsistencyLevel");
        if (consistencyLevel != null) {
            okRequest.addHeader("ConsistencyLevel", consistencyLevel);
        }
        if (request.getMethod().equals("POST")) {
            String body = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            okRequest.post(RequestBody.create((String)body, (MediaType)MediaType.get((String)request.getHeader("Content-Type"))));
        }
        if ((accept = request.getHeader("Accept")) != null) {
            okRequest.addHeader("Accept", accept);
        }
        if ((ifMatch = request.getHeader("If-Match")) != null) {
            okRequest.addHeader("If-Match", ifMatch);
        }
        return okRequest.build();
    }

    private String buildUrl(StaplerRequest2 request, String baseUrl) {
        Authentication authentication;
        String apiUrl = baseUrl;
        if (request.getRestOfPath().startsWith("/beta")) {
            apiUrl = baseUrl.replace("/v1.0", "");
        }
        StringBuilder builder = new StringBuilder(apiUrl);
        String path = Strings.CS.removeStart(request.getRestOfPath(), (CharSequence)"/v1.0");
        if (path.startsWith("/me") && (authentication = SecurityContextHolder.getContext().getAuthentication()) instanceof AzureAuthenticationToken) {
            String objectID = ((AzureAuthenticationToken)authentication).getAzureAdUser().getObjectID();
            path = path.replace("me", "users/" + objectID);
        }
        builder.append(path);
        if (request.getQueryString() != null) {
            builder.append("?").append(request.getQueryString());
        }
        return builder.toString();
    }

    @Extension
    public static class TransientActionFactoryComputer
    extends TransientActionFactory<Computer> {
        public Class<Computer> type() {
            return Computer.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull Computer target) {
            return Collections.singletonList(new GraphProxy((AccessControlled)target));
        }
    }

    @Extension
    public static class TransientActionFactoryImpl
    extends TransientActionFactory<AbstractItem> {
        public Class<AbstractItem> type() {
            return AbstractItem.class;
        }

        @NonNull
        public Collection<? extends Action> createFor(@NonNull AbstractItem target) {
            return Collections.singletonList(new GraphProxy((AccessControlled)target));
        }
    }
}

