/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class DeprecationUtil {
    private DeprecationUtil() {
    }

    public static void logDeprecationMessage() {
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        if (stackTrace.length < 3) {
            return;
        }
        StackTraceElement calledDeprecatedMethod = stackTrace[1];
        StackTraceElement caller = stackTrace[2];
        Logger.getLogger(calledDeprecatedMethod.getClassName()).log(Level.INFO, () -> "Deprecated method " + calledDeprecatedMethod.getClassName() + "#" + calledDeprecatedMethod.getMethodName() + " called by " + caller.getClassName());
    }
}

