/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DirectoryObjectCollectionReferenceRequest;
import com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesPage;
import com.microsoft.graph.requests.DirectoryObjectCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.jenkins.azuread.AzureAdGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Request;

public final class AzureCachePool {
    private static final Logger LOGGER = Logger.getLogger(AzureCachePool.class.getName());
    private static Cache<String, List<AzureAdGroup>> belongingGroupsByOid = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private final GraphServiceClient<Request> azure;

    private AzureCachePool(GraphServiceClient<Request> azure) {
        this.azure = azure;
    }

    public static AzureCachePool get(GraphServiceClient<Request> azure) {
        return new AzureCachePool(azure);
    }

    public List<AzureAdGroup> getBelongingGroupsByOid(String oid) {
        List result = (List)belongingGroupsByOid.get((Object)oid, cacheKey -> {
            try {
                DirectoryObjectCollectionWithReferencesPage collection = (DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)this.azure.users(oid).transitiveMemberOf().buildRequest(new Option[0])).get();
                ArrayList<AzureAdGroup> groups = new ArrayList<AzureAdGroup>();
                while (collection != null) {
                    List directoryObjects = collection.getCurrentPage();
                    List<AzureAdGroup> groupsFromPage = directoryObjects.stream().map(group -> {
                        if (group instanceof Group) {
                            return new AzureAdGroup(group.id, ((Group)group).displayName);
                        }
                        return null;
                    }).filter(Objects::nonNull).toList();
                    groups.addAll(groupsFromPage);
                    DirectoryObjectCollectionWithReferencesRequestBuilder nextPage = (DirectoryObjectCollectionWithReferencesRequestBuilder)collection.getNextPage();
                    if (nextPage == null) break;
                    collection = (DirectoryObjectCollectionWithReferencesPage)((DirectoryObjectCollectionReferenceRequest)nextPage.buildRequest(new Option[0])).get();
                }
                return groups;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Do not have sufficient privileges to fetch your belonging groups' authorities.", e);
                return Collections.emptyList();
            }
        });
        return result;
    }

    public static void invalidateBelongingGroupsByOid(String userId) {
        belongingGroupsByOid.invalidate((Object)userId);
    }
}

