/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.microsoft.graph.models.User;
import com.microsoft.jenkins.azuread.AzureAdGroup;
import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public final class AzureAdUser
implements UserDetails {
    private static final long serialVersionUID = 1779209037664572820L;
    private String name;
    private String uniqueName;
    private String tenantID;
    private String objectID;
    private String email;
    private List<String> groupOIDs;
    private volatile List<GrantedAuthority> authorities = Collections.singletonList(SecurityRealm.AUTHENTICATED_AUTHORITY2);

    private AzureAdUser() {
    }

    public static AzureAdUser createFromActiveDirectoryUser(User activeDirectoryUser) {
        if (activeDirectoryUser == null) {
            return null;
        }
        AzureAdUser user = new AzureAdUser();
        user.name = activeDirectoryUser.displayName;
        user.uniqueName = activeDirectoryUser.userPrincipalName;
        user.objectID = activeDirectoryUser.id;
        user.email = activeDirectoryUser.mail;
        user.groupOIDs = new LinkedList<String>();
        return user;
    }

    public static AzureAdUser createFromJwt(JwtClaims claims) {
        String emailRegEx;
        Pattern r;
        Matcher m;
        if (claims == null) {
            return null;
        }
        AzureAdUser user = new AzureAdUser();
        user.name = (String)claims.getClaimValue("name");
        user.uniqueName = (String)claims.getClaimValue("upn");
        if (StringUtils.isEmpty((String)user.uniqueName)) {
            user.uniqueName = (String)claims.getClaimValue("preferred_username");
        }
        user.tenantID = (String)claims.getClaimValue("tid");
        user.objectID = (String)claims.getClaimValue("oid");
        user.email = (String)claims.getClaimValue("email");
        if (user.email == null && user.uniqueName.contains("@")) {
            user.email = user.uniqueName;
        }
        try {
            user.groupOIDs = claims.getStringListClaimValue("groups");
        }
        catch (MalformedClaimException e) {
            throw new RuntimeException(e);
        }
        if (user.groupOIDs == null) {
            user.groupOIDs = new LinkedList<String>();
        }
        if (user.objectID == null || user.name == null) {
            throw new BadCredentialsException("Invalid id token: " + claims.toJson());
        }
        if ((user.email == null || user.email.isEmpty()) && (m = (r = Pattern.compile(emailRegEx = "^(.*#)?([A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6})$", 2)).matcher(user.uniqueName)).find()) {
            user.email = m.group(2);
        }
        return user;
    }

    public void setAuthorities(List<AzureAdGroup> groups, String userPrincipalName) {
        ArrayList<GrantedAuthority> newAuthorities = new ArrayList<GrantedAuthority>();
        if (!groups.isEmpty()) {
            for (AzureAdGroup group : groups) {
                newAuthorities.add(group);
                newAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(group.getGroupName()));
            }
        } else {
            for (String groupOID : this.groupOIDs) {
                newAuthorities.add(new AzureAdGroup(groupOID, groupOID));
            }
        }
        newAuthorities.add(SecurityRealm.AUTHENTICATED_AUTHORITY2);
        newAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.objectID));
        newAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(userPrincipalName));
        this.authorities = newAuthorities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAdUser that = (AzureAdUser)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.uniqueName, that.uniqueName)) {
            return false;
        }
        if (!Objects.equals(this.tenantID, that.tenantID)) {
            return false;
        }
        if (this.groupOIDs != null && that.groupOIDs != null ? !CollectionUtils.isEqualCollection(this.groupOIDs, that.groupOIDs) : this.groupOIDs != null || that.groupOIDs != null) {
            return false;
        }
        return this.objectID.equals(that.objectID);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.uniqueName != null ? this.uniqueName.hashCode() : 0);
        result = 31 * result + (this.tenantID != null ? this.tenantID.hashCode() : 0);
        result = 31 * result + (this.groupOIDs != null ? this.groupOIDs.hashCode() : 0);
        result = 31 * result + this.objectID.hashCode();
        return result;
    }

    public List<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return "";
    }

    public String getUsername() {
        return this.getObjectID();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getTenantID() {
        return this.tenantID;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public List<String> getGroupOIDs() {
        return this.groupOIDs;
    }

    public String toString() {
        return "AzureAdUser{name='" + this.name + "', uniqueName='" + this.uniqueName + "', tenantID='" + this.tenantID + "', objectID='" + this.objectID + "', email='" + this.email + "', groups='" + this.groupOIDs.toString() + "', authorities=" + String.valueOf(this.authorities) + "}";
    }
}

