/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.models.User;
import com.microsoft.graph.options.HeaderOption;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.GraphServiceClient;
import com.microsoft.graph.requests.GroupCollectionPage;
import com.microsoft.graph.requests.GroupCollectionRequest;
import com.microsoft.graph.requests.UserCollectionPage;
import com.microsoft.graph.requests.UserCollectionRequest;
import com.microsoft.jenkins.azuread.AuthorizationContainer;
import com.microsoft.jenkins.azuread.AuthorizationMatrixNodeProperty;
import com.microsoft.jenkins.azuread.AuthorizationType;
import com.microsoft.jenkins.azuread.AzureAdAuthorizationMatrixFolderProperty;
import com.microsoft.jenkins.azuread.AzureAdAuthorizationMatrixNodeProperty;
import com.microsoft.jenkins.azuread.AzureAdAuthorizationMatrixProperty;
import com.microsoft.jenkins.azuread.AzureObject;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import com.microsoft.jenkins.azuread.GlobalMatrixAuthorizationStrategy;
import com.microsoft.jenkins.azuread.ObjId2FullSidMap;
import com.microsoft.jenkins.azuread.PermissionEntry;
import com.microsoft.jenkins.azuread.ValidationUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import okhttp3.Request;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;

public class AzureAdMatrixAuthorizationStrategy
extends GlobalMatrixAuthorizationStrategy {
    private static final Logger LOGGER = Logger.getLogger(AzureAdMatrixAuthorizationStrategy.class.getName());
    private final transient ObjId2FullSidMap objId2FullSidMap = new ObjId2FullSidMap();

    @DataBoundConstructor
    public AzureAdMatrixAuthorizationStrategy() {
    }

    @NonNull
    public ACL getACL(@NonNull Job<?, ?> project) {
        AzureAdAuthorizationMatrixProperty amp = (AzureAdAuthorizationMatrixProperty)project.getProperty(AzureAdAuthorizationMatrixProperty.class);
        if (amp != null) {
            return amp.getInheritanceStrategy().getEffectiveACL((ACL)amp.getACL(), project);
        }
        return this.getACL(project.getParent());
    }

    @NonNull
    public ACL getACL(@NonNull Node node) {
        AuthorizationMatrixNodeProperty property = (AuthorizationMatrixNodeProperty)node.getNodeProperty(AzureAdAuthorizationMatrixNodeProperty.class);
        if (property != null) {
            return property.getInheritanceStrategy().getEffectiveACL((ACL)property.getACL(), (AccessControlled)node);
        }
        return this.getRootACL();
    }

    @Restricted(value={NoExternalUse.class})
    public static ACL inheritingACL(final ACL parent, final ACL child) {
        if (parent instanceof SidACL && child instanceof SidACL) {
            return ((SidACL)child).newInheritingACL((SidACL)parent);
        }
        return new ACL(){

            public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
                return a.equals(SYSTEM2) || child.hasPermission2(a, permission) || parent.hasPermission2(a, permission);
            }
        };
    }

    public ACL getACL(ItemGroup<?> g) {
        if (g instanceof Item) {
            Item item = (Item)g;
            return item.getACL();
        }
        return this.getRootACL();
    }

    @NonNull
    public ACL getACL(@NonNull AbstractItem item) {
        AzureAdAuthorizationMatrixFolderProperty p;
        if (Jenkins.get().getPlugin("cloudbees-folder") != null && item instanceof AbstractFolder && (p = (AzureAdAuthorizationMatrixFolderProperty)((AbstractFolder)item).getProperties().get(AzureAdAuthorizationMatrixFolderProperty.class)) != null) {
            return p.getInheritanceStrategy().getEffectiveACL((ACL)p.getACL(), (AccessControlled)item);
        }
        return this.getACL(item.getParent());
    }

    @Override
    @NonNull
    public Set<String> getGroups() {
        TreeSet<String> r = new TreeSet<String>(new AuthorizationContainer.IdStrategyComparator());
        r.addAll(super.getGroups());
        for (Job j : Jenkins.get().getAllItems(Job.class)) {
            AzureAdAuthorizationMatrixProperty jobProperty = (AzureAdAuthorizationMatrixProperty)j.getProperty(AzureAdAuthorizationMatrixProperty.class);
            if (jobProperty == null) continue;
            r.addAll(jobProperty.getGroups());
        }
        for (Job j : Jenkins.get().getAllItems(AbstractFolder.class)) {
            AzureAdAuthorizationMatrixFolderProperty folderProperty = (AzureAdAuthorizationMatrixFolderProperty)j.getProperties().get(AzureAdAuthorizationMatrixFolderProperty.class);
            if (folderProperty == null) continue;
            r.addAll(folderProperty.getGroups());
        }
        return r;
    }

    @Override
    public void add(Permission p, PermissionEntry entry) {
        super.add(p, entry);
        this.objId2FullSidMap.putFullSid(entry.getSid());
    }

    @Override
    public boolean hasExplicitPermission(PermissionEntry entry, Permission p) {
        if (entry.getSid() == null) {
            return false;
        }
        PermissionEntry entry1 = new PermissionEntry(entry.getType(), this.objId2FullSidMap.getOrOriginal(entry.getSid()));
        return super.hasExplicitPermission(entry1, p);
    }

    @Override
    public boolean hasPermission(String sid, Permission p, boolean principal) {
        return super.hasPermission(this.objId2FullSidMap.getOrOriginal(sid), p, principal);
    }

    static AutoCompletionCandidates searchAndGenerateCandidates(String prefix) {
        int maxCandidates = 20;
        if (StringUtils.isEmpty((String)prefix)) {
            return null;
        }
        SecurityRealm realm = Jenkins.get().getSecurityRealm();
        if (!(realm instanceof AzureSecurityRealm)) {
            return null;
        }
        GraphServiceClient<Request> graphClient = ((AzureSecurityRealm)realm).getAzureClient();
        ArrayList<AzureObject> candidates = new ArrayList<AzureObject>();
        LOGGER.info("search users with prefix: " + prefix);
        try {
            UserCollectionPage users = AzureAdMatrixAuthorizationStrategy.lookupUsers(prefix, graphClient);
            for (Object user : users.getCurrentPage()) {
                candidates.add(new AzureObject(((User)user).id, ((User)user).displayName));
                if (candidates.size() <= 20) continue;
                break;
            }
            if (candidates.size() < 20) {
                GroupCollectionPage groupCollectionPage = AzureAdMatrixAuthorizationStrategy.lookupGroups(prefix, graphClient);
                for (Group group : groupCollectionPage.getCurrentPage()) {
                    candidates.add(new AzureObject(group.id, group.displayName));
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Do not have sufficient privileges to search related users or groups", e);
        }
        AutoCompletionCandidates c = new AutoCompletionCandidates();
        for (AzureObject obj : candidates) {
            String candidateText = ObjId2FullSidMap.generateFullSid(obj.getDisplayName(), obj.getObjectId());
            c.add(candidateText);
        }
        return c;
    }

    private static GroupCollectionPage lookupGroups(String prefix, GraphServiceClient<Request> graphClient) {
        LinkedList<Object> requestOptions = new LinkedList<Object>();
        String search = String.format("\"displayName:%s\"", prefix);
        requestOptions.add(new QueryOption("$search", (Object)search));
        requestOptions.add(new HeaderOption("ConsistencyLevel", "eventual"));
        return (GroupCollectionPage)((GroupCollectionRequest)graphClient.groups().buildRequest(requestOptions)).orderBy("displayName").select("id,displayName").get();
    }

    private static UserCollectionPage lookupUsers(String prefix, GraphServiceClient<Request> graphClient) {
        LinkedList<Object> requestOptions = new LinkedList<Object>();
        String search = String.format("\"displayName:%s\" OR \"userPrincipalName:%s\"", prefix, prefix);
        requestOptions.add(new QueryOption("$search", (Object)search));
        requestOptions.add(new HeaderOption("ConsistencyLevel", "eventual"));
        return (UserCollectionPage)((UserCollectionRequest)graphClient.users().buildRequest(requestOptions)).select("id,displayName").orderBy("displayName").get();
    }

    @Initializer(before=InitMilestone.PLUGINS_STARTED)
    public static void fixClassNameTypo() {
        Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.jenkins.azuread.AzureAdMatrixAuthorizationStategy", AzureAdMatrixAuthorizationStrategy.class);
    }

    @Restricted(value={DoNotUse.class})
    public static class ConverterImpl
    extends GlobalMatrixAuthorizationStrategy.ConverterImpl {
        @Override
        public GlobalMatrixAuthorizationStrategy create() {
            return new AzureAdMatrixAuthorizationStrategy();
        }

        @Override
        public boolean canConvert(Class type) {
            return type == AzureAdMatrixAuthorizationStrategy.class;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends GlobalMatrixAuthorizationStrategy.DescriptorImpl {
        @Override
        protected GlobalMatrixAuthorizationStrategy create() {
            return new AzureAdMatrixAuthorizationStrategy();
        }

        @Override
        @NonNull
        public String getDisplayName() {
            return "Entra ID Matrix-based security";
        }

        public boolean isDisableGraphIntegration() {
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            if (securityRealm instanceof AzureSecurityRealm) {
                AzureSecurityRealm azureSecurityRealm = (AzureSecurityRealm)securityRealm;
                return azureSecurityRealm.isDisableGraphIntegration();
            }
            return true;
        }

        @Override
        public FormValidation doCheckName(String value) {
            AuthorizationType type;
            String unbracketedValue = value.substring(1, value.length() - 1);
            Jenkins subject = Jenkins.get();
            Permission permission = Jenkins.ADMINISTER;
            int splitIndex = unbracketedValue.indexOf(58);
            if (splitIndex < 0) {
                return FormValidation.error((String)("No type prefix: " + unbracketedValue));
            }
            String typeString = unbracketedValue.substring(0, splitIndex);
            try {
                type = AuthorizationType.valueOf(typeString);
            }
            catch (Exception ex) {
                return FormValidation.error((String)("Invalid type prefix: " + unbracketedValue));
            }
            String sid = unbracketedValue.substring(splitIndex + 1);
            String escapedSid = Functions.escape((String)sid);
            if (!subject.hasPermission(permission)) {
                if (type == AuthorizationType.USER) {
                    return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, escapedSid, "User may or may not exist"));
                }
                if (type == AuthorizationType.GROUP) {
                    return FormValidation.okWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Group may or may not exist"));
                }
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.EITHER, escapedSid, "Permissions would be granted to a user or group of this name"));
            }
            SecurityRealm sr = Jenkins.get().getSecurityRealm();
            if (sid.equals("authenticated") && type == AuthorizationType.EITHER) {
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.GROUP, escapedSid, "Internal group found; but permissions would also be granted to a user of this name"));
            }
            if (sid.equals("anonymous") && type == AuthorizationType.EITHER) {
                return FormValidation.warningWithMarkup((String)ValidationUtil.formatUserGroupValidationResponse(AuthorizationType.USER, escapedSid, "Internal user found; but permissions would also be granted to a group of this name"));
            }
            try {
                switch (type) {
                    case GROUP: {
                        FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, false);
                        if (groupValidation != null) {
                            return groupValidation;
                        }
                        return FormValidation.errorWithMarkup((String)ValidationUtil.formatNonExistentUserGroupValidationResponse(escapedSid, "Group not found"));
                    }
                    case USER: {
                        FormValidation userValidation = ValidationUtil.validateUser(sid, sr, false);
                        if (userValidation != null) {
                            return userValidation;
                        }
                        return FormValidation.errorWithMarkup((String)ValidationUtil.formatNonExistentUserGroupValidationResponse(escapedSid, "User not found"));
                    }
                    case EITHER: {
                        FormValidation userValidation = ValidationUtil.validateUser(sid, sr, true);
                        if (userValidation != null) {
                            return userValidation;
                        }
                        FormValidation groupValidation = ValidationUtil.validateGroup(sid, sr, true);
                        if (groupValidation != null) {
                            return groupValidation;
                        }
                        return FormValidation.errorWithMarkup((String)ValidationUtil.formatNonExistentUserGroupValidationResponse(escapedSid, "User or group not found"));
                    }
                }
                return FormValidation.error((String)("Unexpected type: " + String.valueOf((Object)type)));
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)escapedSid);
            }
        }
    }
}

