/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.microsoft.jenkins.azuread.AbstractAuthorizationPropertyConverter;
import com.microsoft.jenkins.azuread.AuthorizationMatrixNodeProperty;
import com.microsoft.jenkins.azuread.AuthorizationPropertyDescriptor;
import com.microsoft.jenkins.azuread.AzureAdMatrixAuthorizationStrategy;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import com.microsoft.jenkins.azuread.ObjId2FullSidMap;
import com.microsoft.jenkins.azuread.PermissionEntry;
import com.microsoft.jenkins.azuread.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.User;
import hudson.security.AccessControlled;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.security.SecurityRealm;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.NodeListener;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class AzureAdAuthorizationMatrixNodeProperty
extends AuthorizationMatrixNodeProperty {
    private final transient ObjId2FullSidMap objId2FullSidMap = new ObjId2FullSidMap();
    private static final Logger LOGGER = Logger.getLogger(AzureAdAuthorizationMatrixNodeProperty.class.getName());

    public AzureAdAuthorizationMatrixNodeProperty() {
        super(Collections.emptyMap());
    }

    void refreshMap() {
        for (PermissionEntry entry : this.getAllPermissionEntries()) {
            this.objId2FullSidMap.putFullSid(entry.getSid());
        }
        new AzureAdAuthorizationMatrixNodeProperty();
    }

    @Override
    public void add(Permission permission, PermissionEntry entry) {
        super.add(permission, entry);
        this.objId2FullSidMap.putFullSid(entry.getSid());
    }

    @Override
    public boolean hasExplicitPermission(PermissionEntry entry, Permission p) {
        String objectId = entry.getSid();
        if (objectId == null) {
            return false;
        }
        String fullSid = this.objId2FullSidMap.getOrOriginal(objectId);
        return super.hasExplicitPermission(new PermissionEntry(entry.getType(), fullSid), p);
    }

    @Override
    public boolean hasPermission(String sid, Permission p, boolean principal) {
        return super.hasPermission(this.objId2FullSidMap.getOrOriginal(sid), p, principal);
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static class NodeListenerImpl
    extends NodeListener {
        protected void onCreated(@NonNull Node node) {
            AuthorizationStrategy authorizationStrategy = Jenkins.get().getAuthorizationStrategy();
            if (authorizationStrategy instanceof AzureAdMatrixAuthorizationStrategy) {
                User current;
                String sid;
                AzureAdMatrixAuthorizationStrategy strategy = (AzureAdMatrixAuthorizationStrategy)authorizationStrategy;
                AuthorizationMatrixNodeProperty prop = (AuthorizationMatrixNodeProperty)node.getNodeProperty(AzureAdAuthorizationMatrixNodeProperty.class);
                if (prop == null) {
                    prop = new AzureAdAuthorizationMatrixNodeProperty();
                }
                String string = sid = (current = User.current()) == null ? "anonymous" : current.getId();
                if (!strategy.getACL(node).hasPermission2(Jenkins.getAuthentication2(), Computer.CONFIGURE)) {
                    prop.add(Computer.CONFIGURE, PermissionEntry.user(sid));
                }
                if (!prop.getGrantedPermissionEntries().isEmpty()) {
                    try {
                        node.getNodeProperties().replace((Describable)prop);
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.WARNING, "Failed to grant creator permissions on node " + node.getDisplayName(), ex);
                    }
                }
            }
        }
    }

    @Extension
    @Symbol(value={"azureAdAuthorizationMatrix"})
    public static class DescriptorImpl
    extends NodePropertyDescriptor
    implements AuthorizationPropertyDescriptor<AzureAdAuthorizationMatrixNodeProperty> {
        @Override
        public AzureAdAuthorizationMatrixNodeProperty create() {
            return new AzureAdAuthorizationMatrixNodeProperty();
        }

        @Override
        public PermissionScope getPermissionScope() {
            return PermissionScope.COMPUTER;
        }

        public AzureAdAuthorizationMatrixNodeProperty newInstance(StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            return (AzureAdAuthorizationMatrixNodeProperty)this.createNewInstance(req, formData, false);
        }

        @Override
        public boolean isApplicable() {
            return Jenkins.get().getAuthorizationStrategy() instanceof AzureAdMatrixAuthorizationStrategy;
        }

        @NonNull
        public String getDisplayName() {
            return "Entra ID Authorization Matrix";
        }

        public boolean isDisableGraphIntegration() {
            SecurityRealm securityRealm = Jenkins.get().getSecurityRealm();
            if (securityRealm instanceof AzureSecurityRealm) {
                AzureSecurityRealm azureSecurityRealm = (AzureSecurityRealm)securityRealm;
                return azureSecurityRealm.isDisableGraphIntegration();
            }
            return true;
        }

        @Restricted(value={DoNotUse.class})
        public FormValidation doCheckName(@AncestorInPath Computer computer, @QueryParameter String value) {
            if (this.isDisableGraphIntegration()) {
                return Utils.undecidableResponse(value);
            }
            return this.doCheckName_(value, (AccessControlled)(computer == null ? Jenkins.get() : computer), computer == null ? Jenkins.ADMINISTER : Computer.CONFIGURE);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class ConverterImpl
    extends AbstractAuthorizationPropertyConverter<AzureAdAuthorizationMatrixNodeProperty> {
        @Override
        public boolean canConvert(Class type) {
            return type == AzureAdAuthorizationMatrixNodeProperty.class;
        }

        @Override
        public AzureAdAuthorizationMatrixNodeProperty create() {
            return new AzureAdAuthorizationMatrixNodeProperty();
        }
    }
}

