/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread.scribe;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class AzureToken
extends OAuth2AccessToken {
    private Long expiryOn;
    private String idToken;

    @JsonCreator
    public AzureToken(@JsonProperty(value="access_token") String accessToken, @JsonProperty(value="token_type") String tokenType, @JsonProperty(value="expires_in") Integer expiresIn, @JsonProperty(value="expiry_on") Long expiryOn, @JsonProperty(value="refresh_token") String refreshToken, @JsonProperty(value="scope") String scope, @JsonProperty(value="id_token") String idToken) {
        super(accessToken, tokenType, expiresIn, refreshToken, scope, null);
        this.expiryOn = expiryOn;
        this.idToken = idToken;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 41 * hash + Objects.hashCode(this.idToken);
        hash = 41 * hash + Objects.hashCode(this.expiryOn);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AzureToken other = (AzureToken)((Object)obj);
        if (!Objects.equals(this.expiryOn, other.getExpiryOn())) {
            return false;
        }
        return Objects.equals(this.idToken, other.getIdToken());
    }

    public Long getExpiryOn() {
        return this.expiryOn;
    }

    public void setExpiryOn(Long expiryOn) {
        this.expiryOn = expiryOn;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public boolean isExpired() {
        return this.expiryOn < TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "AzureToken{access_token=" + this.getAccessToken() + ", token_type=" + this.getTokenType() + ", expires_in=" + this.getExpiresIn() + ", refresh_token=" + this.getRefreshToken() + ", scope=" + this.getScope() + ", open_id_token=" + this.idToken + "}";
    }
}

