/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread.oauth;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.microsoft.jenkins.azuread.AzureSecurityRealm;
import jakarta.servlet.http.HttpSession;
import java.time.Duration;
import java.util.UUID;

public class StateCache {
    public static final Cache<String, CacheHolder> CACHE = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(Duration.ofMinutes(30L)).build();

    public String generateValue(HttpSession session) {
        String referer = session.getAttribute(AzureSecurityRealm.REFERER_ATTRIBUTE).toString();
        Long beginTime = (Long)session.getAttribute(AzureSecurityRealm.TIMESTAMP_ATTRIBUTE);
        String nonce = session.getAttribute(AzureSecurityRealm.NONCE_ATTRIBUTE).toString();
        String state = UUID.randomUUID().toString();
        CACHE.put((Object)state, (Object)new CacheHolder(referer, beginTime, nonce));
        return state;
    }

    public record CacheHolder(String referrer, Long beginTime, String nonce) {
    }
}

