/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import hudson.Functions;
import hudson.ProxyConfiguration;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public final class Utils {
    private Utils() {
    }

    public static FormValidation undecidableResponse(String value) {
        String v = value.substring(1, value.length() - 1);
        String ev = Functions.escape((String)v);
        return FormValidation.respond((FormValidation.Kind)FormValidation.Kind.OK, (String)ev);
    }

    public static class JwtUtil {
        public static final long DEFAULT_CACHE_DURATION = TimeUnit.HOURS.toSeconds(24L);

        public static JwtConsumer jwt(String authorityHost, String clientId, String tenantId) {
            String keyDiscoveryUrl = String.format("%s%s/discovery/keys?appId=%s", authorityHost, tenantId, clientId);
            String expectedIssuer = String.format("%s%s/v2.0", authorityHost, tenantId);
            HttpsJwks httpsJwks = new HttpsJwks(keyDiscoveryUrl);
            httpsJwks.setDefaultCacheDuration(DEFAULT_CACHE_DURATION);
            ProxyConfiguration proxy = Jenkins.get().getProxy();
            if (proxy != null) {
                Get get = new Get();
                try {
                    get.setHttpProxy(proxy.createProxy(new URI(authorityHost).getHost()));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                httpsJwks.setSimpleHttpGet((SimpleGet)get);
            }
            HttpsJwksVerificationKeyResolver httpsJwksKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
            return new JwtConsumerBuilder().setVerificationKeyResolver((VerificationKeyResolver)httpsJwksKeyResolver).setExpectedIssuer(expectedIssuer).setExpectedAudience(new String[]{clientId}).setRequireNotBefore().setRequireExpirationTime().build();
        }
    }

    public static class JsonUtil {
        private static ObjectMapper mapper = new ObjectMapper();

        public static <T> T fromJson(String json, Class<T> klazz) {
            try {
                return (T)mapper.readValue(json, klazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static <T> String toJson(T obj) {
            try {
                return mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        static {
            mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }

    public static class UUIDUtil {
        private static final Pattern UUID_PATTERN = Pattern.compile("(?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-5][0-9a-f]{3}-?[089ab][0-9a-f]{3}-?[0-9a-f]{12}$");

        public static final boolean isValidUuid(String uuid) {
            return uuid != null && UUID_PATTERN.matcher(uuid).matches();
        }
    }
}

