/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import com.microsoft.jenkins.azuread.AuthorizationType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PermissionEntry
implements Comparable<PermissionEntry> {
    private final AuthorizationType type;
    private final String sid;

    public PermissionEntry(@NonNull AuthorizationType type, @NonNull String sid) {
        this.type = type;
        this.sid = sid;
    }

    public AuthorizationType getType() {
        return this.type;
    }

    public String getSid() {
        return this.sid;
    }

    protected boolean isApplicable(boolean principal) {
        if (this.getType() == AuthorizationType.EITHER) {
            return true;
        }
        return this.getType() == (principal ? AuthorizationType.USER : AuthorizationType.GROUP);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static PermissionEntry fromString(@NonNull String permissionEntryString) {
        AuthorizationType type;
        Objects.requireNonNull(permissionEntryString);
        int idx = permissionEntryString.indexOf(58);
        if (idx < 0) {
            return null;
        }
        String typeString = permissionEntryString.substring(0, idx);
        try {
            type = AuthorizationType.valueOf(typeString);
        }
        catch (RuntimeException ex) {
            return null;
        }
        String sid = permissionEntryString.substring(idx + 1);
        if (sid.isEmpty()) {
            return null;
        }
        return new PermissionEntry(type, sid);
    }

    public static PermissionEntry user(String sid) {
        return new PermissionEntry(AuthorizationType.USER, sid);
    }

    public static PermissionEntry group(String sid) {
        return new PermissionEntry(AuthorizationType.GROUP, sid);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionEntry that = (PermissionEntry)o;
        return this.type == that.type && this.sid.equals(that.sid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.sid});
    }

    public String toString() {
        return "PermissionEntry{type=" + String.valueOf((Object)this.type) + ", sid='" + this.sid + "'}";
    }

    @Override
    public int compareTo(@NonNull PermissionEntry o) {
        int type = this.getType().compareTo(o.getType());
        if (type != 0) {
            return type;
        }
        return this.getSid().compareTo(o.getSid());
    }
}

