/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.azuread;

import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class AzureEnvironment {
    public static final String AZURE_PUBLIC_CLOUD = "Azure";
    public static final String AZURE_CHINA = "Azure China";
    public static final String AZURE_US_GOVERNMENT_L4 = "Azure US Government L4";
    public static final String AZURE_US_GOVERNMENT_L5 = "Azure US Government L5 (DOD)";

    private AzureEnvironment() {
    }

    static String getAuthorityHost(String azureEnvironmentName) {
        return switch (azureEnvironmentName) {
            case AZURE_CHINA -> "https://login.partner.microsoftonline.cn/";
            case AZURE_US_GOVERNMENT_L4, AZURE_US_GOVERNMENT_L5 -> "https://login.microsoftonline.us/";
            default -> "https://login.microsoftonline.com/";
        };
    }

    static String getGraphResource(String azureEnv) {
        switch (azureEnv) {
            case "Azure China": {
                return "https://microsoftgraph.chinacloudapi.cn/";
            }
            case "Azure US Government L4": {
                return "https://graph.microsoft.us/";
            }
            case "Azure US Government L5 (DOD)": {
                return "https://dod-graph.microsoft.us/";
            }
        }
        return "https://graph.microsoft.com/";
    }

    static String getServiceRoot(String azureEnv) {
        return AzureEnvironment.getGraphResource(azureEnv) + "v1.0";
    }
}

