/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.HostPort;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HostPortRequest
extends BaseRequest<HostPort> {
    public HostPortRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, HostPort.class);
    }

    @Nonnull
    public CompletableFuture<HostPort> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public HostPort get() throws ClientException {
        return (HostPort)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<HostPort> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public HostPort delete() throws ClientException {
        return (HostPort)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<HostPort> patchAsync(@Nonnull HostPort sourceHostPort) {
        return this.sendAsync(HttpMethod.PATCH, sourceHostPort);
    }

    @Nullable
    public HostPort patch(@Nonnull HostPort sourceHostPort) throws ClientException {
        return (HostPort)this.send(HttpMethod.PATCH, sourceHostPort);
    }

    @Nonnull
    public CompletableFuture<HostPort> postAsync(@Nonnull HostPort newHostPort) {
        return this.sendAsync(HttpMethod.POST, newHostPort);
    }

    @Nullable
    public HostPort post(@Nonnull HostPort newHostPort) throws ClientException {
        return (HostPort)this.send(HttpMethod.POST, newHostPort);
    }

    @Nonnull
    public CompletableFuture<HostPort> putAsync(@Nonnull HostPort newHostPort) {
        return this.sendAsync(HttpMethod.PUT, newHostPort);
    }

    @Nullable
    public HostPort put(@Nonnull HostPort newHostPort) throws ClientException {
        return (HostPort)this.send(HttpMethod.PUT, newHostPort);
    }

    @Nonnull
    public HostPortRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public HostPortRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

