/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.ContentType;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ContentTypeRequest
extends BaseRequest<ContentType> {
    public ContentTypeRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContentType.class);
    }

    @Nonnull
    public CompletableFuture<ContentType> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public ContentType get() throws ClientException {
        return (ContentType)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<ContentType> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public ContentType delete() throws ClientException {
        return (ContentType)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<ContentType> patchAsync(@Nonnull ContentType sourceContentType) {
        return this.sendAsync(HttpMethod.PATCH, sourceContentType);
    }

    @Nullable
    public ContentType patch(@Nonnull ContentType sourceContentType) throws ClientException {
        return (ContentType)this.send(HttpMethod.PATCH, sourceContentType);
    }

    @Nonnull
    public CompletableFuture<ContentType> postAsync(@Nonnull ContentType newContentType) {
        return this.sendAsync(HttpMethod.POST, newContentType);
    }

    @Nullable
    public ContentType post(@Nonnull ContentType newContentType) throws ClientException {
        return (ContentType)this.send(HttpMethod.POST, newContentType);
    }

    @Nonnull
    public CompletableFuture<ContentType> putAsync(@Nonnull ContentType newContentType) {
        return this.sendAsync(HttpMethod.PUT, newContentType);
    }

    @Nullable
    public ContentType put(@Nonnull ContentType newContentType) throws ClientException {
        return (ContentType)this.send(HttpMethod.PUT, newContentType);
    }

    @Nonnull
    public ContentTypeRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ContentTypeRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

