/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.identitygovernance.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.identitygovernance.models.WorkflowVersion;
import com.microsoft.graph.identitygovernance.requests.WorkflowVersionCollectionPage;
import com.microsoft.graph.identitygovernance.requests.WorkflowVersionCollectionRequestBuilder;
import com.microsoft.graph.identitygovernance.requests.WorkflowVersionCollectionResponse;
import com.microsoft.graph.identitygovernance.requests.WorkflowVersionRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkflowVersionCollectionRequest
extends BaseEntityCollectionRequest<WorkflowVersion, WorkflowVersionCollectionResponse, WorkflowVersionCollectionPage> {
    public WorkflowVersionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkflowVersionCollectionResponse.class, WorkflowVersionCollectionPage.class, WorkflowVersionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<WorkflowVersion> postAsync(@Nonnull WorkflowVersion newWorkflowVersion) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkflowVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newWorkflowVersion);
    }

    @Nonnull
    public WorkflowVersion post(@Nonnull WorkflowVersion newWorkflowVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WorkflowVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWorkflowVersion);
    }

    @Nonnull
    public WorkflowVersionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public WorkflowVersionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

