/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.supplier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.Filter;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsRequest;
import software.amazon.awssdk.services.secretsmanager.model.ListSecretsResponse;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;

class ListSecretsOperation
implements Supplier<Collection<SecretListEntry>> {
    private final SecretsManagerClient client;
    private final Collection<Filter> filters;

    ListSecretsOperation(SecretsManagerClient client, Collection<Filter> filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public Collection<SecretListEntry> get() {
        ListSecretsResponse result;
        ArrayList<SecretListEntry> secretList = new ArrayList<SecretListEntry>();
        Optional<Object> nextToken = Optional.empty();
        do {
            ListSecretsRequest.Builder request = ListSecretsRequest.builder().filters(this.filters);
            nextToken.ifPresent(nt -> request.nextToken(nt));
            result = this.client.listSecrets((ListSecretsRequest)request.build());
            List<SecretListEntry> secrets = result.secretList().stream().filter(ListSecretsOperation::isNotDeleted).toList();
            secretList.addAll(secrets);
        } while ((nextToken = Optional.ofNullable(result.nextToken())).isPresent());
        return secretList;
    }

    private static boolean isNotDeleted(SecretListEntry entry) {
        return entry.deletedDate() == null;
    }
}

