/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.supplier;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import io.jenkins.plugins.credentials.secretsmanager.FiltersFactory;
import io.jenkins.plugins.credentials.secretsmanager.config.Client;
import io.jenkins.plugins.credentials.secretsmanager.config.Filter;
import io.jenkins.plugins.credentials.secretsmanager.config.ListSecrets;
import io.jenkins.plugins.credentials.secretsmanager.config.PluginConfiguration;
import io.jenkins.plugins.credentials.secretsmanager.config.Transformations;
import io.jenkins.plugins.credentials.secretsmanager.config.transformer.name.Default;
import io.jenkins.plugins.credentials.secretsmanager.factory.CredentialsFactory;
import io.jenkins.plugins.credentials.secretsmanager.supplier.ListSecretsOperation;
import io.jenkins.plugins.credentials.secretsmanager.supplier.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.model.SecretListEntry;
import software.amazon.awssdk.services.secretsmanager.model.Tag;

public class CredentialsSupplier
implements Supplier<Collection<StandardCredentials>> {
    private static final Logger LOG = Logger.getLogger(CredentialsSupplier.class.getName());

    private CredentialsSupplier() {
    }

    public static Supplier<Collection<StandardCredentials>> standard() {
        return new CredentialsSupplier();
    }

    @Override
    public Collection<StandardCredentials> get() {
        LOG.log(Level.FINE, "Retrieve secrets from AWS Secrets Manager");
        PluginConfiguration config = PluginConfiguration.getInstance();
        Function<String, String> nameFormatter = CredentialsSupplier.createNameFormatter(config);
        Function<String, String> descriptionFormatter = CredentialsSupplier.createDescriptionFormatter(config);
        Collection<software.amazon.awssdk.services.secretsmanager.model.Filter> filters = CredentialsSupplier.createListSecretsFilters(config);
        SecretsManagerClient client = CredentialsSupplier.createClient(config);
        ListSecretsOperation listSecretsOperation = new ListSecretsOperation(client, filters);
        Object secretList = listSecretsOperation.get();
        return secretList.stream().map(secretListEntry -> {
            String name = secretListEntry.name();
            String description = Optional.ofNullable(secretListEntry.description()).orElse("");
            return (SecretListEntry)secretListEntry.copy(builder -> {
                builder.name((String)nameFormatter.apply(name));
                builder.description((String)descriptionFormatter.apply(description));
            });
        }).flatMap(secretListEntry -> {
            String arn = secretListEntry.arn();
            String name = secretListEntry.name();
            String description = secretListEntry.description();
            Map<String, String> tags = Lists.toMap(secretListEntry.tags(), Tag::key, Tag::value);
            Optional<StandardCredentials> cred = CredentialsFactory.create(arn, name, description, tags, client);
            return cred.stream();
        }).collect(Collectors.toList());
    }

    private static Collection<software.amazon.awssdk.services.secretsmanager.model.Filter> createListSecretsFilters(PluginConfiguration config) {
        List<Filter> filtersConfig = Optional.ofNullable(config.getListSecrets()).map(ListSecrets::getFilters).orElse(Collections.emptyList());
        return FiltersFactory.create(filtersConfig);
    }

    private static Function<String, String> createNameFormatter(PluginConfiguration config) {
        return Optional.ofNullable(config.getTransformations()).map(Transformations::getName).orElse(new Default())::transform;
    }

    private static Function<String, String> createDescriptionFormatter(PluginConfiguration config) {
        return Optional.ofNullable(config.getTransformations()).map(Transformations::getDescription).orElse(new io.jenkins.plugins.credentials.secretsmanager.config.transformer.description.Default())::transform;
    }

    private static SecretsManagerClient createClient(PluginConfiguration config) {
        Client clientConfig = Optional.ofNullable(config.getClient()).orElse(new Client(null, null, null, null));
        return clientConfig.build();
    }
}

