/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider;

import hudson.Extension;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.CredentialsProvider;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class ProfileCredentialsProvider
extends CredentialsProvider {
    private String profileName;

    @DataBoundConstructor
    public ProfileCredentialsProvider(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    @DataBoundSetter
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Override
    public AwsCredentialsProvider build() {
        return software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider.builder().profileName(this.profileName).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileCredentialsProvider that = (ProfileCredentialsProvider)o;
        return Objects.equals(this.profileName, that.profileName);
    }

    public int hashCode() {
        return Objects.hash(this.profileName);
    }

    @Extension
    @Symbol(value={"profile"})
    public static class DescriptorImpl
    extends CredentialsProvider.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return Messages.profile();
        }
    }
}

