/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.credentials.secretsmanager.Messages;
import io.jenkins.plugins.credentials.secretsmanager.config.credentialsProvider.CredentialsProvider;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AWSStaticCredentialsProvider
extends CredentialsProvider {
    private String accessKey;
    private Secret secretKey;

    @DataBoundConstructor
    public AWSStaticCredentialsProvider(String accessKey, Secret secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    @Override
    public AWSCredentialsProvider build() {
        String secretKey = this.secretKey.getPlainText();
        BasicAWSCredentials creds = new BasicAWSCredentials(this.accessKey, secretKey);
        return new com.amazonaws.auth.AWSStaticCredentialsProvider((AWSCredentials)creds);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    @DataBoundSetter
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public Secret getSecretKey() {
        return this.secretKey;
    }

    @DataBoundSetter
    public void setSecretKey(Secret secretKey) {
        this.secretKey = secretKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSStaticCredentialsProvider that = (AWSStaticCredentialsProvider)o;
        return Objects.equals(this.accessKey, that.accessKey) && Objects.equals(this.secretKey, that.secretKey);
    }

    public int hashCode() {
        return Objects.hash(this.accessKey, this.secretKey);
    }

    @Extension
    @Symbol(value={"static"})
    public static class DescriptorImpl
    extends CredentialsProvider.DescriptorImpl {
        @Nonnull
        public String getDisplayName() {
            return Messages.statik();
        }

        public FormValidation doCheckAccessKey(@QueryParameter String accessKey) {
            if (Util.fixEmptyAndTrim((String)accessKey) == null) {
                return FormValidation.error((String)"AWS Access Key must not be empty");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSecretKey(@QueryParameter Secret secretKey) {
            if (Util.fixEmptyAndTrim((String)secretKey.getPlainText()) == null) {
                return FormValidation.error((String)"AWS Secret Key must not be empty");
            }
            return FormValidation.ok();
        }
    }
}

