/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionMetadata;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;

public class DescribeAutomationExecutionsIterable
implements SdkIterable<DescribeAutomationExecutionsResponse> {
    private final SsmClient client;
    private final DescribeAutomationExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAutomationExecutionsIterable(SsmClient client, DescribeAutomationExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeAutomationExecutionsResponseFetcher();
    }

    public Iterator<DescribeAutomationExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutomationExecutionMetadata> automationExecutionMetadataList() {
        Function<DescribeAutomationExecutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automationExecutionMetadataList() != null) {
                return response.automationExecutionMetadataList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAutomationExecutionsResponseFetcher
    implements SyncPageFetcher<DescribeAutomationExecutionsResponse> {
        private DescribeAutomationExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutomationExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAutomationExecutionsResponse nextPage(DescribeAutomationExecutionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutomationExecutionsIterable.this.client.describeAutomationExecutions(DescribeAutomationExecutionsIterable.this.firstRequest);
            }
            return DescribeAutomationExecutionsIterable.this.client.describeAutomationExecutions((DescribeAutomationExecutionsRequest)((Object)DescribeAutomationExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

