/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.internal.UserAgentUtils;
import software.amazon.awssdk.services.organizations.model.EffectivePolicyValidationError;
import software.amazon.awssdk.services.organizations.model.ListEffectivePolicyValidationErrorsRequest;
import software.amazon.awssdk.services.organizations.model.ListEffectivePolicyValidationErrorsResponse;

public class ListEffectivePolicyValidationErrorsPublisher
implements SdkPublisher<ListEffectivePolicyValidationErrorsResponse> {
    private final OrganizationsAsyncClient client;
    private final ListEffectivePolicyValidationErrorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEffectivePolicyValidationErrorsPublisher(OrganizationsAsyncClient client, ListEffectivePolicyValidationErrorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEffectivePolicyValidationErrorsPublisher(OrganizationsAsyncClient client, ListEffectivePolicyValidationErrorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEffectivePolicyValidationErrorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEffectivePolicyValidationErrorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EffectivePolicyValidationError> effectivePolicyValidationErrors() {
        Function<ListEffectivePolicyValidationErrorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.effectivePolicyValidationErrors() != null) {
                return response.effectivePolicyValidationErrors().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEffectivePolicyValidationErrorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEffectivePolicyValidationErrorsResponseFetcher
    implements AsyncPageFetcher<ListEffectivePolicyValidationErrorsResponse> {
        private ListEffectivePolicyValidationErrorsResponseFetcher() {
        }

        public boolean hasNextPage(ListEffectivePolicyValidationErrorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEffectivePolicyValidationErrorsResponse> nextPage(ListEffectivePolicyValidationErrorsResponse previousPage) {
            if (previousPage == null) {
                return ListEffectivePolicyValidationErrorsPublisher.this.client.listEffectivePolicyValidationErrors(ListEffectivePolicyValidationErrorsPublisher.this.firstRequest);
            }
            return ListEffectivePolicyValidationErrorsPublisher.this.client.listEffectivePolicyValidationErrors((ListEffectivePolicyValidationErrorsRequest)((Object)ListEffectivePolicyValidationErrorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

