/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HandshakeResourceType {
    ACCOUNT("ACCOUNT"),
    ORGANIZATION("ORGANIZATION"),
    ORGANIZATION_FEATURE_SET("ORGANIZATION_FEATURE_SET"),
    EMAIL("EMAIL"),
    MASTER_EMAIL("MASTER_EMAIL"),
    MASTER_NAME("MASTER_NAME"),
    NOTES("NOTES"),
    PARENT_HANDSHAKE("PARENT_HANDSHAKE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HandshakeResourceType> VALUE_MAP;
    private final String value;

    private HandshakeResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandshakeResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandshakeResourceType> knownValues() {
        EnumSet<HandshakeResourceType> knownValues = EnumSet.allOf(HandshakeResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HandshakeResourceType.class, HandshakeResourceType::toString);
    }
}

