/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.organizations.model.CreateAccountFailureReason;
import software.amazon.awssdk.services.organizations.model.CreateAccountState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccountStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateAccountStatus> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(CreateAccountStatus.getter(CreateAccountStatus::id)).setter(CreateAccountStatus.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountName").getter(CreateAccountStatus.getter(CreateAccountStatus::accountName)).setter(CreateAccountStatus.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CreateAccountStatus.getter(CreateAccountStatus::stateAsString)).setter(CreateAccountStatus.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> REQUESTED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RequestedTimestamp").getter(CreateAccountStatus.getter(CreateAccountStatus::requestedTimestamp)).setter(CreateAccountStatus.setter(Builder::requestedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedTimestamp").build()}).build();
    private static final SdkField<Instant> COMPLETED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletedTimestamp").getter(CreateAccountStatus.getter(CreateAccountStatus::completedTimestamp)).setter(CreateAccountStatus.setter(Builder::completedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedTimestamp").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(CreateAccountStatus.getter(CreateAccountStatus::accountId)).setter(CreateAccountStatus.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> GOV_CLOUD_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GovCloudAccountId").getter(CreateAccountStatus.getter(CreateAccountStatus::govCloudAccountId)).setter(CreateAccountStatus.setter(Builder::govCloudAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GovCloudAccountId").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(CreateAccountStatus.getter(CreateAccountStatus::failureReasonAsString)).setter(CreateAccountStatus.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ACCOUNT_NAME_FIELD, STATE_FIELD, REQUESTED_TIMESTAMP_FIELD, COMPLETED_TIMESTAMP_FIELD, ACCOUNT_ID_FIELD, GOV_CLOUD_ACCOUNT_ID_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccountStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String accountName;
    private final String state;
    private final Instant requestedTimestamp;
    private final Instant completedTimestamp;
    private final String accountId;
    private final String govCloudAccountId;
    private final String failureReason;

    private CreateAccountStatus(BuilderImpl builder) {
        this.id = builder.id;
        this.accountName = builder.accountName;
        this.state = builder.state;
        this.requestedTimestamp = builder.requestedTimestamp;
        this.completedTimestamp = builder.completedTimestamp;
        this.accountId = builder.accountId;
        this.govCloudAccountId = builder.govCloudAccountId;
        this.failureReason = builder.failureReason;
    }

    public final String id() {
        return this.id;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final CreateAccountState state() {
        return CreateAccountState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant requestedTimestamp() {
        return this.requestedTimestamp;
    }

    public final Instant completedTimestamp() {
        return this.completedTimestamp;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String govCloudAccountId() {
        return this.govCloudAccountId;
    }

    public final CreateAccountFailureReason failureReason() {
        return CreateAccountFailureReason.fromValue(this.failureReason);
    }

    public final String failureReasonAsString() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.govCloudAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReasonAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountStatus)) {
            return false;
        }
        CreateAccountStatus other = (CreateAccountStatus)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.requestedTimestamp(), other.requestedTimestamp()) && Objects.equals(this.completedTimestamp(), other.completedTimestamp()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.govCloudAccountId(), other.govCloudAccountId()) && Objects.equals(this.failureReasonAsString(), other.failureReasonAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccountStatus").add("Id", (Object)this.id()).add("AccountName", (Object)(this.accountName() == null ? null : "*** Sensitive Data Redacted ***")).add("State", (Object)this.stateAsString()).add("RequestedTimestamp", (Object)this.requestedTimestamp()).add("CompletedTimestamp", (Object)this.completedTimestamp()).add("AccountId", (Object)this.accountId()).add("GovCloudAccountId", (Object)this.govCloudAccountId()).add("FailureReason", (Object)this.failureReasonAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "AccountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RequestedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.requestedTimestamp()));
            }
            case "CompletedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.completedTimestamp()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "GovCloudAccountId": {
                return Optional.ofNullable(clazz.cast(this.govCloudAccountId()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReasonAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("AccountName", ACCOUNT_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("RequestedTimestamp", REQUESTED_TIMESTAMP_FIELD);
        map.put("CompletedTimestamp", COMPLETED_TIMESTAMP_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("GovCloudAccountId", GOV_CLOUD_ACCOUNT_ID_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountStatus, T> g) {
        return obj -> g.apply((CreateAccountStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String accountName;
        private String state;
        private Instant requestedTimestamp;
        private Instant completedTimestamp;
        private String accountId;
        private String govCloudAccountId;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountStatus model) {
            this.id(model.id);
            this.accountName(model.accountName);
            this.state(model.state);
            this.requestedTimestamp(model.requestedTimestamp);
            this.completedTimestamp(model.completedTimestamp);
            this.accountId(model.accountId);
            this.govCloudAccountId(model.govCloudAccountId);
            this.failureReason(model.failureReason);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CreateAccountState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getRequestedTimestamp() {
            return this.requestedTimestamp;
        }

        public final void setRequestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
        }

        @Override
        public final Builder requestedTimestamp(Instant requestedTimestamp) {
            this.requestedTimestamp = requestedTimestamp;
            return this;
        }

        public final Instant getCompletedTimestamp() {
            return this.completedTimestamp;
        }

        public final void setCompletedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
        }

        @Override
        public final Builder completedTimestamp(Instant completedTimestamp) {
            this.completedTimestamp = completedTimestamp;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getGovCloudAccountId() {
            return this.govCloudAccountId;
        }

        public final void setGovCloudAccountId(String govCloudAccountId) {
            this.govCloudAccountId = govCloudAccountId;
        }

        @Override
        public final Builder govCloudAccountId(String govCloudAccountId) {
            this.govCloudAccountId = govCloudAccountId;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public final Builder failureReason(CreateAccountFailureReason failureReason) {
            this.failureReason(failureReason == null ? null : failureReason.toString());
            return this;
        }

        public CreateAccountStatus build() {
            return new CreateAccountStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateAccountStatus> {
        public Builder id(String var1);

        public Builder accountName(String var1);

        public Builder state(String var1);

        public Builder state(CreateAccountState var1);

        public Builder requestedTimestamp(Instant var1);

        public Builder completedTimestamp(Instant var1);

        public Builder accountId(String var1);

        public Builder govCloudAccountId(String var1);

        public Builder failureReason(String var1);

        public Builder failureReason(CreateAccountFailureReason var1);
    }
}

