/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BundleType {
    TAR("tar"),
    TGZ("tgz"),
    ZIP("zip"),
    YAML("YAML"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BundleType> VALUE_MAP;
    private final String value;

    private BundleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BundleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BundleType> knownValues() {
        EnumSet<BundleType> knownValues = EnumSet.allOf(BundleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BundleType.class, BundleType::toString);
    }
}

