/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3OriginConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3OriginConfig> {
    private static final SdkField<String> ORIGIN_ACCESS_IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginAccessIdentity").getter(S3OriginConfig.getter(S3OriginConfig::originAccessIdentity)).setter(S3OriginConfig.setter(Builder::originAccessIdentity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessIdentity").unmarshallLocationName("OriginAccessIdentity").build()}).build();
    private static final SdkField<Integer> ORIGIN_READ_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OriginReadTimeout").getter(S3OriginConfig.getter(S3OriginConfig::originReadTimeout)).setter(S3OriginConfig.setter(Builder::originReadTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginReadTimeout").unmarshallLocationName("OriginReadTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_IDENTITY_FIELD, ORIGIN_READ_TIMEOUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3OriginConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String originAccessIdentity;
    private final Integer originReadTimeout;

    private S3OriginConfig(BuilderImpl builder) {
        this.originAccessIdentity = builder.originAccessIdentity;
        this.originReadTimeout = builder.originReadTimeout;
    }

    public final String originAccessIdentity() {
        return this.originAccessIdentity;
    }

    public final Integer originReadTimeout() {
        return this.originReadTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(this.originReadTimeout());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3OriginConfig)) {
            return false;
        }
        S3OriginConfig other = (S3OriginConfig)obj;
        return Objects.equals(this.originAccessIdentity(), other.originAccessIdentity()) && Objects.equals(this.originReadTimeout(), other.originReadTimeout());
    }

    public final String toString() {
        return ToString.builder((String)"S3OriginConfig").add("OriginAccessIdentity", (Object)this.originAccessIdentity()).add("OriginReadTimeout", (Object)this.originReadTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginAccessIdentity": {
                return Optional.ofNullable(clazz.cast(this.originAccessIdentity()));
            }
            case "OriginReadTimeout": {
                return Optional.ofNullable(clazz.cast(this.originReadTimeout()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OriginAccessIdentity", ORIGIN_ACCESS_IDENTITY_FIELD);
        map.put("OriginReadTimeout", ORIGIN_READ_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3OriginConfig, T> g) {
        return obj -> g.apply((S3OriginConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String originAccessIdentity;
        private Integer originReadTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(S3OriginConfig model) {
            this.originAccessIdentity(model.originAccessIdentity);
            this.originReadTimeout(model.originReadTimeout);
        }

        public final String getOriginAccessIdentity() {
            return this.originAccessIdentity;
        }

        public final void setOriginAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
        }

        @Override
        public final Builder originAccessIdentity(String originAccessIdentity) {
            this.originAccessIdentity = originAccessIdentity;
            return this;
        }

        public final Integer getOriginReadTimeout() {
            return this.originReadTimeout;
        }

        public final void setOriginReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
        }

        @Override
        public final Builder originReadTimeout(Integer originReadTimeout) {
            this.originReadTimeout = originReadTimeout;
            return this;
        }

        public S3OriginConfig build() {
            return new S3OriginConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3OriginConfig> {
        public Builder originAccessIdentity(String var1);

        public Builder originReadTimeout(Integer var1);
    }
}

