/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MinimumProtocolVersion {
    SSL_V3("SSLv3"),
    TLS_V1("TLSv1"),
    TLS_V1_2016("TLSv1_2016"),
    TLS_V1_1_2016("TLSv1.1_2016"),
    TLS_V1_2_2018("TLSv1.2_2018"),
    TLS_V1_2_2019("TLSv1.2_2019"),
    TLS_V1_2_2021("TLSv1.2_2021"),
    TLS_V1_3_2025("TLSv1.3_2025"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MinimumProtocolVersion> VALUE_MAP;
    private final String value;

    private MinimumProtocolVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MinimumProtocolVersion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MinimumProtocolVersion> knownValues() {
        EnumSet<MinimumProtocolVersion> knownValues = EnumSet.allOf(MinimumProtocolVersion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MinimumProtocolVersion.class, MinimumProtocolVersion::toString);
    }
}

