/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOriginAccessControlResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetOriginAccessControlResponse> {
    private static final SdkField<OriginAccessControl> ORIGIN_ACCESS_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginAccessControl").getter(GetOriginAccessControlResponse.getter(GetOriginAccessControlResponse::originAccessControl)).setter(GetOriginAccessControlResponse.setter(Builder::originAccessControl)).constructor(OriginAccessControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControl").unmarshallLocationName("OriginAccessControl").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetOriginAccessControlResponse.getter(GetOriginAccessControlResponse::eTag)).setter(GetOriginAccessControlResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGIN_ACCESS_CONTROL_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOriginAccessControlResponse.memberNameToFieldInitializer();
    private final OriginAccessControl originAccessControl;
    private final String eTag;

    private GetOriginAccessControlResponse(BuilderImpl builder) {
        super(builder);
        this.originAccessControl = builder.originAccessControl;
        this.eTag = builder.eTag;
    }

    public final OriginAccessControl originAccessControl() {
        return this.originAccessControl;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.originAccessControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOriginAccessControlResponse)) {
            return false;
        }
        GetOriginAccessControlResponse other = (GetOriginAccessControlResponse)((Object)obj);
        return Objects.equals(this.originAccessControl(), other.originAccessControl()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetOriginAccessControlResponse").add("OriginAccessControl", (Object)this.originAccessControl()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OriginAccessControl": {
                return Optional.ofNullable(clazz.cast(this.originAccessControl()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OriginAccessControl", ORIGIN_ACCESS_CONTROL_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOriginAccessControlResponse, T> g) {
        return obj -> g.apply((GetOriginAccessControlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private OriginAccessControl originAccessControl;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOriginAccessControlResponse model) {
            super(model);
            this.originAccessControl(model.originAccessControl);
            this.eTag(model.eTag);
        }

        public final OriginAccessControl.Builder getOriginAccessControl() {
            return this.originAccessControl != null ? this.originAccessControl.toBuilder() : null;
        }

        public final void setOriginAccessControl(OriginAccessControl.BuilderImpl originAccessControl) {
            this.originAccessControl = originAccessControl != null ? originAccessControl.build() : null;
        }

        @Override
        public final Builder originAccessControl(OriginAccessControl originAccessControl) {
            this.originAccessControl = originAccessControl;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetOriginAccessControlResponse build() {
            return new GetOriginAccessControlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOriginAccessControlResponse> {
        public Builder originAccessControl(OriginAccessControl var1);

        default public Builder originAccessControl(Consumer<OriginAccessControl.Builder> originAccessControl) {
            return this.originAccessControl((OriginAccessControl)((OriginAccessControl.Builder)OriginAccessControl.builder().applyMutation(originAccessControl)).build());
        }

        public Builder eTag(String var1);
    }
}

