/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.GeoRestrictionType;
import software.amazon.awssdk.services.cloudfront.model.LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoRestrictionCustomization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoRestrictionCustomization> {
    private static final SdkField<String> RESTRICTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RestrictionType").getter(GeoRestrictionCustomization.getter(GeoRestrictionCustomization::restrictionTypeAsString)).setter(GeoRestrictionCustomization.setter(Builder::restrictionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestrictionType").unmarshallLocationName("RestrictionType").build()}).build();
    private static final SdkField<List<String>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locations").getter(GeoRestrictionCustomization.getter(GeoRestrictionCustomization::locations)).setter(GeoRestrictionCustomization.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").unmarshallLocationName("Locations").build(), ListTrait.builder().memberLocationName("Location").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").unmarshallLocationName("Location").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESTRICTION_TYPE_FIELD, LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GeoRestrictionCustomization.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String restrictionType;
    private final List<String> locations;

    private GeoRestrictionCustomization(BuilderImpl builder) {
        this.restrictionType = builder.restrictionType;
        this.locations = builder.locations;
    }

    public final GeoRestrictionType restrictionType() {
        return GeoRestrictionType.fromValue(this.restrictionType);
    }

    public final String restrictionTypeAsString() {
        return this.restrictionType;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<String> locations() {
        return this.locations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoRestrictionCustomization)) {
            return false;
        }
        GeoRestrictionCustomization other = (GeoRestrictionCustomization)obj;
        return Objects.equals(this.restrictionTypeAsString(), other.restrictionTypeAsString()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations());
    }

    public final String toString() {
        return ToString.builder((String)"GeoRestrictionCustomization").add("RestrictionType", (Object)this.restrictionTypeAsString()).add("Locations", this.hasLocations() ? this.locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RestrictionType": {
                return Optional.ofNullable(clazz.cast(this.restrictionTypeAsString()));
            }
            case "Locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RestrictionType", RESTRICTION_TYPE_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GeoRestrictionCustomization, T> g) {
        return obj -> g.apply((GeoRestrictionCustomization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String restrictionType;
        private List<String> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GeoRestrictionCustomization model) {
            this.restrictionType(model.restrictionType);
            this.locations(model.locations);
        }

        public final String getRestrictionType() {
            return this.restrictionType;
        }

        public final void setRestrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
        }

        @Override
        public final Builder restrictionType(String restrictionType) {
            this.restrictionType = restrictionType;
            return this;
        }

        @Override
        public final Builder restrictionType(GeoRestrictionType restrictionType) {
            this.restrictionType(restrictionType == null ? null : restrictionType.toString());
            return this;
        }

        public final Collection<String> getLocations() {
            if (this.locations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.locations;
        }

        public final void setLocations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
        }

        @Override
        public final Builder locations(Collection<String> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(String ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        public GeoRestrictionCustomization build() {
            return new GeoRestrictionCustomization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoRestrictionCustomization> {
        public Builder restrictionType(String var1);

        public Builder restrictionType(GeoRestrictionType var1);

        public Builder locations(Collection<String> var1);

        public Builder locations(String ... var1);
    }
}

