/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.cloudfront.auth.scheme.CloudFrontAuthSchemeParams;
import software.amazon.awssdk.services.cloudfront.auth.scheme.internal.DefaultCloudFrontAuthSchemeProvider;
import software.amazon.awssdk.services.cloudfront.auth.scheme.internal.PreferredCloudFrontAuthSchemeProvider;

@SdkPublicApi
public interface CloudFrontAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(CloudFrontAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<CloudFrontAuthSchemeParams.Builder> consumer) {
        CloudFrontAuthSchemeParams.Builder builder = CloudFrontAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static CloudFrontAuthSchemeProvider defaultProvider() {
        return DefaultCloudFrontAuthSchemeProvider.create();
    }

    public static CloudFrontAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredCloudFrontAuthSchemeProvider(CloudFrontAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

