/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ResourceMapping;
import software.amazon.awssdk.services.cloudformation.model.ResourceMappingsCopier;
import software.amazon.awssdk.services.cloudformation.model.StackDefinition;
import software.amazon.awssdk.services.cloudformation.model.StackDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStackRefactorRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, CreateStackRefactorRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateStackRefactorRequest.getter(CreateStackRefactorRequest::description)).setter(CreateStackRefactorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> ENABLE_STACK_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableStackCreation").getter(CreateStackRefactorRequest.getter(CreateStackRefactorRequest::enableStackCreation)).setter(CreateStackRefactorRequest.setter(Builder::enableStackCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableStackCreation").build()}).build();
    private static final SdkField<List<ResourceMapping>> RESOURCE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceMappings").getter(CreateStackRefactorRequest.getter(CreateStackRefactorRequest::resourceMappings)).setter(CreateStackRefactorRequest.setter(Builder::resourceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StackDefinition>> STACK_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackDefinitions").getter(CreateStackRefactorRequest.getter(CreateStackRefactorRequest::stackDefinitions)).setter(CreateStackRefactorRequest.setter(Builder::stackDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ENABLE_STACK_CREATION_FIELD, RESOURCE_MAPPINGS_FIELD, STACK_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateStackRefactorRequest.memberNameToFieldInitializer();
    private final String description;
    private final Boolean enableStackCreation;
    private final List<ResourceMapping> resourceMappings;
    private final List<StackDefinition> stackDefinitions;

    private CreateStackRefactorRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.enableStackCreation = builder.enableStackCreation;
        this.resourceMappings = builder.resourceMappings;
        this.stackDefinitions = builder.stackDefinitions;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean enableStackCreation() {
        return this.enableStackCreation;
    }

    public final boolean hasResourceMappings() {
        return this.resourceMappings != null && !(this.resourceMappings instanceof SdkAutoConstructList);
    }

    public final List<ResourceMapping> resourceMappings() {
        return this.resourceMappings;
    }

    public final boolean hasStackDefinitions() {
        return this.stackDefinitions != null && !(this.stackDefinitions instanceof SdkAutoConstructList);
    }

    public final List<StackDefinition> stackDefinitions() {
        return this.stackDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableStackCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceMappings() ? this.resourceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackDefinitions() ? this.stackDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRefactorRequest)) {
            return false;
        }
        CreateStackRefactorRequest other = (CreateStackRefactorRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.enableStackCreation(), other.enableStackCreation()) && this.hasResourceMappings() == other.hasResourceMappings() && Objects.equals(this.resourceMappings(), other.resourceMappings()) && this.hasStackDefinitions() == other.hasStackDefinitions() && Objects.equals(this.stackDefinitions(), other.stackDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"CreateStackRefactorRequest").add("Description", (Object)this.description()).add("EnableStackCreation", (Object)this.enableStackCreation()).add("ResourceMappings", this.hasResourceMappings() ? this.resourceMappings() : null).add("StackDefinitions", this.hasStackDefinitions() ? this.stackDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EnableStackCreation": {
                return Optional.ofNullable(clazz.cast(this.enableStackCreation()));
            }
            case "ResourceMappings": {
                return Optional.ofNullable(clazz.cast(this.resourceMappings()));
            }
            case "StackDefinitions": {
                return Optional.ofNullable(clazz.cast(this.stackDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("EnableStackCreation", ENABLE_STACK_CREATION_FIELD);
        map.put("ResourceMappings", RESOURCE_MAPPINGS_FIELD);
        map.put("StackDefinitions", STACK_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRefactorRequest, T> g) {
        return obj -> g.apply((CreateStackRefactorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String description;
        private Boolean enableStackCreation;
        private List<ResourceMapping> resourceMappings = DefaultSdkAutoConstructList.getInstance();
        private List<StackDefinition> stackDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRefactorRequest model) {
            super(model);
            this.description(model.description);
            this.enableStackCreation(model.enableStackCreation);
            this.resourceMappings(model.resourceMappings);
            this.stackDefinitions(model.stackDefinitions);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getEnableStackCreation() {
            return this.enableStackCreation;
        }

        public final void setEnableStackCreation(Boolean enableStackCreation) {
            this.enableStackCreation = enableStackCreation;
        }

        @Override
        public final Builder enableStackCreation(Boolean enableStackCreation) {
            this.enableStackCreation = enableStackCreation;
            return this;
        }

        public final List<ResourceMapping.Builder> getResourceMappings() {
            List<ResourceMapping.Builder> result = ResourceMappingsCopier.copyToBuilder(this.resourceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceMappings(Collection<ResourceMapping.BuilderImpl> resourceMappings) {
            this.resourceMappings = ResourceMappingsCopier.copyFromBuilder(resourceMappings);
        }

        @Override
        public final Builder resourceMappings(Collection<ResourceMapping> resourceMappings) {
            this.resourceMappings = ResourceMappingsCopier.copy(resourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(ResourceMapping ... resourceMappings) {
            this.resourceMappings(Arrays.asList(resourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceMappings(Consumer<ResourceMapping.Builder> ... resourceMappings) {
            this.resourceMappings(Stream.of(resourceMappings).map(c -> (ResourceMapping)((ResourceMapping.Builder)ResourceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StackDefinition.Builder> getStackDefinitions() {
            List<StackDefinition.Builder> result = StackDefinitionsCopier.copyToBuilder(this.stackDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackDefinitions(Collection<StackDefinition.BuilderImpl> stackDefinitions) {
            this.stackDefinitions = StackDefinitionsCopier.copyFromBuilder(stackDefinitions);
        }

        @Override
        public final Builder stackDefinitions(Collection<StackDefinition> stackDefinitions) {
            this.stackDefinitions = StackDefinitionsCopier.copy(stackDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackDefinitions(StackDefinition ... stackDefinitions) {
            this.stackDefinitions(Arrays.asList(stackDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackDefinitions(Consumer<StackDefinition.Builder> ... stackDefinitions) {
            this.stackDefinitions(Stream.of(stackDefinitions).map(c -> (StackDefinition)((StackDefinition.Builder)StackDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRefactorRequest build() {
            return new CreateStackRefactorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStackRefactorRequest> {
        public Builder description(String var1);

        public Builder enableStackCreation(Boolean var1);

        public Builder resourceMappings(Collection<ResourceMapping> var1);

        public Builder resourceMappings(ResourceMapping ... var1);

        public Builder resourceMappings(Consumer<ResourceMapping.Builder> ... var1);

        public Builder stackDefinitions(Collection<StackDefinition> var1);

        public Builder stackDefinitions(StackDefinition ... var1);

        public Builder stackDefinitions(Consumer<StackDefinition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

