/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.util;

import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public final class FormValidationUtils {
    public static FormValidation checkBaseUrl(String baseUrl) {
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            return FormValidation.error((String)"You must enter a valid HTTP URL");
        }
        try {
            URL base = new URL(baseUrl);
            if (StringUtils.isBlank((CharSequence)base.getHost())) {
                return FormValidation.error((String)"This isn't a valid URL. Check for typos and make sure to include http:// or https://");
            }
            if (base.getHost().endsWith("bitbucket.org")) {
                return FormValidation.error((String)"This plugin does not support connecting to bitbucket.org. It is for Bitbucket Server instances only.");
            }
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"This isn't a valid URL. Check for typos and make sure to include http:// or https://");
        }
        return FormValidation.ok();
    }
}

