/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import hudson.Util;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.scm.PollingResult;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.triggers.SCMTriggerItem;

public class BitbucketTriggerWorker
implements Runnable {
    private static final Action[] ACTION_ARRAY = new Action[0];
    private static final Logger LOGGER = Logger.getLogger(BitbucketTriggerWorker.class.getName());
    private final List<Action> actions = new ArrayList<Action>();
    @CheckForNull
    private final Job<?, ?> job;
    private final SCMTriggerItem triggerItem;

    public BitbucketTriggerWorker(@CheckForNull Job<?, ?> job, SCMTriggerItem triggerItem, Action causeAction, List<Action> additionalActions) {
        this.actions.add(causeAction);
        this.actions.addAll(additionalActions);
        this.triggerItem = triggerItem;
        this.job = job;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketTriggerWorker runner = (BitbucketTriggerWorker)o;
        return Objects.equals(this.job, runner.job);
    }

    public int hashCode() {
        return Objects.hash(this.job);
    }

    @Override
    public void run() {
        if (this.job == null) {
            return;
        }
        File logFile = new File(this.job.getRootDir(), "bitbucket-webhook-trigger.log");
        try (StreamTaskListener listener = new StreamTaskListener(logFile);){
            long start = System.currentTimeMillis();
            PrintStream logger = listener.getLogger();
            logger.println("Starting polling: " + DateFormat.getDateTimeInstance().format(new Date(start)));
            PollingResult result = this.triggerItem.poll((TaskListener)listener);
            logger.println("Poll complete. Took " + Util.getTimeSpanString((long)(System.currentTimeMillis() - start)));
            if (result.hasChanges()) {
                logger.println("Changes since last build: " + String.valueOf(result.change));
                this.triggerItem.scheduleBuild2(0, this.actions.toArray(ACTION_ARRAY));
            }
        }
        catch (IOException | RuntimeException e) {
            LOGGER.log(Level.SEVERE, String.format("Failed to trigger job %s because an error occurred while writing the polling log to %s", this.job, logFile.getPath()), e);
        }
    }

    public List<Action> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @CheckForNull
    public Job<?, ?> getJob() {
        return this.job;
    }

    public SCMTriggerItem getTriggerItem() {
        return this.triggerItem;
    }
}

