/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm.filesystem;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketFilePathClient;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketBranchSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketTagSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.filesystem.BitbucketSCMFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.BranchSpec;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.util.FormValidation;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;

public class BitbucketSCMFileSystem
extends SCMFileSystem {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMFileSystem.class.getName());
    private final BitbucketFilePathClient client;
    private final String ref;

    protected BitbucketSCMFileSystem(BitbucketFilePathClient client, @Nullable SCMRevision scmRevision, @Nullable String ref) {
        super(scmRevision);
        this.client = client;
        this.ref = ref;
    }

    public SCMFile getRoot() {
        return new BitbucketSCMFile(this.client, this.ref);
    }

    public long lastModified() {
        return 0L;
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        @Inject
        BitbucketClientFactoryProvider clientFactoryProvider;
        @Inject
        JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;
        @Inject
        BitbucketPluginConfiguration pluginConfiguration;

        public SCMFileSystem build(Item item, SCM scm, @CheckForNull SCMRevision scmRevision) {
            if (!(scm instanceof BitbucketSCM)) {
                return null;
            }
            BitbucketSCM bitbucketSCM = (BitbucketSCM)scm;
            Optional<BitbucketServerConfiguration> maybeServerConfiguration = this.pluginConfiguration.getServerById(bitbucketSCM.getServerId());
            if (!maybeServerConfiguration.isPresent() || maybeServerConfiguration.get().validate().kind == FormValidation.Kind.ERROR) {
                LOGGER.finer("ERROR: Bitbucket Server configuration for job " + item.getName() + " is invalid- cannot build file system");
                return null;
            }
            BitbucketSCMRepository repository = bitbucketSCM.getBitbucketSCMRepository();
            BitbucketFilePathClient filePathClient = this.clientFactoryProvider.getClient(maybeServerConfiguration.get().getBaseUrl(), this.jenkinsToBitbucketCredentials.toBitbucketCredentials(repository.getCredentialsId(), item)).getProjectClient(repository.getProjectKey()).getRepositoryClient(repository.getRepositorySlug()).getFilePathClient();
            return new BitbucketSCMFileSystem(filePathClient, null, bitbucketSCM.getBranches().get(0).toString());
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public SCMFileSystem build(SCMSource source, SCMHead head, @CheckForNull SCMRevision scmRevision) {
            Optional<BitbucketServerConfiguration> maybeServerConfiguration;
            if (!(source instanceof BitbucketSCMSource)) {
                return null;
            }
            BitbucketSCMSource bitbucketSCMSource = (BitbucketSCMSource)source;
            String ownerName = "";
            if (source.getOwner() != null && source.getOwner().getName() != null) {
                ownerName = source.getOwner().getName();
            }
            if (!(maybeServerConfiguration = this.pluginConfiguration.getServerById(bitbucketSCMSource.getServerId())).isPresent() || maybeServerConfiguration.get().validate().kind == FormValidation.Kind.ERROR) {
                LOGGER.warning("ERROR: Bitbucket Server configuration for job " + ownerName + " is invalid- cannot continue lightweight checkout");
                return null;
            }
            BitbucketSCMRepository repository = bitbucketSCMSource.getBitbucketSCMRepository();
            BitbucketFilePathClient filePathClient = this.clientFactoryProvider.getClient(maybeServerConfiguration.get().getBaseUrl(), this.jenkinsToBitbucketCredentials.toBitbucketCredentials(repository.getCredentialsId(), (Item)source.getOwner())).getProjectClient(repository.getProjectKey()).getRepositoryClient(repository.getRepositorySlug()).getFilePathClient();
            if (scmRevision != null && (scmRevision.getHead() instanceof BitbucketBranchSCMHead || scmRevision.getHead() instanceof BitbucketTagSCMHead)) {
                return new BitbucketSCMFileSystem(filePathClient, scmRevision, ((BitbucketSCMHead)scmRevision.getHead()).getFullRef());
            }
            LOGGER.finer("Lightweight checkout for Bitbucket SCM source only supported for Multibranch Pipeline jobs. Cannot build file system for job " + ownerName);
            return null;
        }

        public boolean supports(SCM scm) {
            if (scm instanceof BitbucketSCM) {
                List<BranchSpec> branchSpecList = ((BitbucketSCM)scm).getBranches();
                if (branchSpecList.size() == 1 && branchSpecList.get(0).toString() != null && (branchSpecList.get(0).toString().startsWith("refs/heads/") || branchSpecList.get(0).toString().startsWith("refs/tags/"))) {
                    return true;
                }
                LOGGER.finer("Branch spec must be in the form 'refs/heads/<branchname>' or 'refs/tags/<tagname>'. Cannot build file system for this job.");
            }
            return false;
        }

        public boolean supports(SCMSource scmSource) {
            return scmSource instanceof BitbucketSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor scmDescriptor) {
            return scmDescriptor instanceof BitbucketSCM.DescriptorImpl;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor scmSourceDescriptor) {
            return scmSourceDescriptor instanceof BitbucketSCMSource.DescriptorImpl;
        }
    }
}

