/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BitbucketProject {
    private final String key;
    private final String name;
    private final String selfLink;

    @JsonCreator
    public BitbucketProject(@CheckForNull @JsonProperty(value="key", required=true) String key, @CheckForNull @JsonProperty(value="links") Map<String, List<BitbucketNamedLink>> links, @CheckForNull @JsonProperty(value="name", required=true) String name) {
        List<BitbucketNamedLink> self;
        this.key = Objects.toString(key, "");
        this.name = Objects.toString(name, "");
        this.selfLink = links != null ? ((self = links.get("self")) != null && !self.isEmpty() ? self.get(0).getHref() : null) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketProject that = (BitbucketProject)o;
        return this.key.equals(that.key) && this.name.equals(that.name) && Objects.equals(this.selfLink, that.selfLink);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.selfLink);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public String getSelfLink() {
        return this.selfLink;
    }
}

